package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * This is the object used typically as the adapter for a combo-box,
 * where the list of (string) elements in the combo-box is provided
 * by the stringTable.
 */
public class ULCStringTable extends ULCTableModel {
	/**
	 * @serial
	 */
	private String[] fData;
/**
 * Constructs a <code>ULCTableModel</code> which from an array of Strings.
 */
public ULCStringTable() {
}
/**
 * Constructs a <code>ULCTableModel</code> which from an array of Strings.
 */
public ULCStringTable(String[] table) {
	this();
	setModel(table);
}
/**
 * Get the array of strings from the model.
 */
public String [] getModel() {
	return fData;
}
/**
 * Returns the object at the specified  row index.
 *
 * @return The <code>Object</code> at row index
 */
public Object getRowAt(int rowIndex) {
	return fData[rowIndex];
}
/**
 * Returns the current number of rows.
 *
 * @return The <code>int</code> number of rows
 */
public int getRowCount() {
	if (fData == null)
		return 0;
	return fData.length;
}
/**
 * Returns the object at the specified key and row index.
 * We ignore the key in this case since we only have a single attribute.
 * If the index is out of range then return the row index as a string appended
 * with ?.
 *
 * @return The <code>Object</code> at key and row index
 */
public Object getValueAt(String key, int rowIndex) {
	if (rowIndex >= 0 && rowIndex < fData.length)
		return fData[rowIndex];
	return rowIndex + "?";
}
/**
 * Set the array of strings into the model.
 */
public void setModel(String[] table) {
	fData = table;
	notify(TABLE_MODEL_CONTENTS_CHANGED, null, -1, -1);
}
}
