package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import java.util.Vector;
/**
 * Implementation of a FormModel which forwards its getValueAt and setValueAt requests
 * to a specific row of a table model.
 * If the tableList property is specified then this row model will automatically track 
 * selection changes in the table or list widget that it is connected to.
 * If the tableList property is not specified then an explicit call to <code>setRow</code> 
 * is needed to specify over which row within the table model that this row model is acting upon.
 */
public class ULCRowModel extends ULCAbstractRowModel implements IForm, IEnabler, IModelOwner {
/**
 *  Constructs a ULCRowModel
 */
public ULCRowModel() {
}
/**
 * Constructs a ULCRowModel based on the specified TableModel.
 *
 * @param table The <code>ULCAbstractTableModel</code> whose values I track.
 */
public ULCRowModel(ULCAbstractTableModel table) {
	super(table);
}
/**
 * Constructs a ULCRowModel based on the specified TableModel and TableList.
 *
 * @param tableModel 	The <code>ULCAbstractTableModel</code> whose values the receiver is using.
 * @param tableList 	The <code>ULCTableList</code> whose current selection the receiver is tracking.
 */
public ULCRowModel(ULCAbstractTableModel tableModel, ULCTableList widget) {
	super(tableModel, widget);
}
/**
 * Return the <code>ULCTableList</code> whose current selection the receiver is tracking.
 */
IIndexedItemList getItemList() {
	if (getList() == null)
		return getTableModel().getIndexedItemList();
	else
		return (IIndexedItemList) getList().getItemList();
}
/**
 * Return the row index on which the receiver is functioning as FormModel.
 * Note: The table model must be set before this method can be called.
 *
 * @deprecated with R3.0, use #getRowIndex instead
 */
public int getRow() {
	return getRowIndex();
}
/**
 * Return the row index on which the receiver is functioning as FormModel.
 * Note: The table model must be set before this method can be called.
 */
public int getRowIndex() {
	return getItemList().getIndexForOid(getCurrentOid());
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	int currentIndex = getRowIndex();
	if (currentIndex != -1)
		a.put("row", currentIndex);
}
/**
 * Update the UI with the new row information.
 *
 * @parm rowid		the oid of the row the receiver is currently using.
 */
protected void sendCurrentOid(int rowId) {
	sendUI("setRow", new Anything(rowId));
}
/**
 * Specify the row on which the receiver is functioning as FormModel.
 * Note: The table model must be set before this method can be called.
 *
 * @param row	The index of the row within the <code>ULCAbstractTableModel</code> whose values
 *				I now represent.
 *
 * @deprecated with R3.0, use #setRowIndex instead.
 */
public void setRow(int row) {
	setRowIndex(row);
}
/**
 * Specify the row on which the receiver is functioning as FormModel.
 * Note: The table model must be set before this method can be called.
 *
 * @param row	The index of the row within the <code>ULCTableList/code> whose values
 *				I now represent.
 */
public void setRowIndex(int index) {
	setCurrentOid(getItemList().getOidForIndex(index));
}
/**
 * Set the the <code>ULCTableList</code> whose current selection the receiver is tracking.
 *
 */
public void setTableList(ULCTableList tableList) {
	setList(tableList);
}
}
