package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;

/**
 * Ensures that the input (to a text-field, say) adheres to the range /
 * rules dictated by a given regular-expression.
 * Note: This class assumes a Regular expression package has been installed in
 * the UI. Currently a regular expression package is NOT shipped with ULC.
 * The user must obtain and install the package as described in the documentation.
 * If the package is not installed all input is considered valid.
 */
public class ULCRegularExpressionValidator extends ULCProxy implements IDataType {
	/**
	 * The expression that will be validated on each keystroke. Default is null
	 * @serial	 
	 */
	protected String fInputFilterExpression = ".";
	/**
	 * The expression that will be validated before the input is returned 
	 * to the application. Default is .
	 * @serial	 
	 */
	protected String fValidateExpression = ".";
/**
 * Default constructor.
 * Creation date: (08-30-99 4:22:14 PM)
 */
public ULCRegularExpressionValidator() {}
/**
 * Construct a <code>ULCRegularExpressionValidator</code> with the specified validateExpression.
 *
 * @param 	validateExpression 
 * 			The expression that will be validated before the input is returned
 * 			to the application.
 */
public ULCRegularExpressionValidator(String validateExpression) {
	fValidateExpression = validateExpression;
}
/**
 * Construct a <code>ULCRegularExpressionValidator</code> with both input and validate expressions.
 * In most cases the <code>inputFilterExpression</code> is less strict compared to the 
 * <code>validateExpression</code>.
 *
 * @param 	validateExpression 
 * 			The expression that will be validated before the input is returned
 * 			to the application.
 * @param 	inputFilterExpression 
 * 			The expression that will be validated on each keystroke.
 */
public ULCRegularExpressionValidator(String validateExpression, String inputFilterExpression) {
	fValidateExpression = validateExpression;
	fInputFilterExpression = inputFilterExpression;
}
/**
 * Answer the inputFilterExpression property.
 * Creation date: (08-30-99 4:18:53 PM)
 * @return java.lang.String
 */
public String getInputFilterExpression() {
	return fInputFilterExpression;
}
/**
 * Answer the validateExpression property.
 * Creation date: (08-30-99 4:18:53 PM)
 * @return java.lang.String
 */
public String getValidateExpression() {
	return fValidateExpression;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (!fValidateExpression.equals("."))
		a.put("regExp", fValidateExpression);
	if (!fInputFilterExpression.equals("."))
		a.put("inputExp", fInputFilterExpression);
}
/**
 * Set the inputFilterExpression property.
 * Creation date: (08-30-99 4:18:53 PM)
 * @return java.lang.String
 */
public void setInputFilterExpression(String newExpression) {
	fInputFilterExpression = newExpression;
}
/**
 * Set the validateExpression property.
 * Creation date: (08-30-99 4:18:53 PM)
 * @return java.lang.String
 */
public void setValidateExpression(String newExpression) {
	fValidateExpression = newExpression;
}
}
