package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;

/**
 * Used for ensuring that the value of a ULCField or ULCLabel is within a
 * pre-defined range. An invalid input (i.e. one outside the given range)
 * will be adjusted to lie within the range - for example if the range is 1 to 10, an input of 11
 * will be changed by the receiver to 10.
 */
public class ULCRangeValidator extends ULCProxy implements IDataType {
	/**
	 * The minimum value allowed for this Validator. Default is 0.0
	 * @serial	 
	 */
	protected double fMin = 0.0;
	/**
	 * The maximum value allowed for this Validator. Default is 100.0
	 * @serial	 
	 */
	protected double fMax = 100.0;
	/**
	 * The boolean when true converts the returned value to an integer. Default is false.
	 * @serial	 
	 */
	protected boolean fIntValue = false;
/**
 * Default constructor.
 * Creation date: (08-30-99 4:14:04 PM)
 */
public ULCRangeValidator() {}
/**
 * Constructs a RangeValidator for the specified range.
 *
 * @param min The <code>double</code> minimum value allowed for this Validator.
 * @param max The <code>double</code> maximum value allowed for this Validator.
 */
public ULCRangeValidator(double min, double max) {
	this (min,max,false);
}
/**
 * Constructs a RangeValidator for the specified range.
 *
 * @param min The <code>double</code> minimum value allowed for this Validator.
 * @param max The <code>double</code> maximum value allowed for this Validator.
 * @param intValue The <code>boolean</code> when set to true converts the values to integers
 */
public ULCRangeValidator(double min, double max, boolean intValue) {
	fMin = min;
	fMax = max;
	fIntValue = intValue;
}
/**
 * Answer the max property.
 * Creation date: (08-30-99 4:08:25 PM)
 * @return boolean
 */
public double getMax() {
	return fMax;
}
/**
 * Answer the min property.
 * Creation date: (08-30-99 4:08:25 PM)
 * @return boolean
 */
public double getMin() {
	return fMin;
}
/**
 * Answer the integer value property.
 * Creation date: (08-30-99 4:08:25 PM)
 * @return boolean
 */
public boolean isInteger() {
	return fIntValue;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fMin != 0.0)
		a.put("min", fMin);
	if (fMax != 100.0)
		a.put("max", fMax);
	if (fIntValue)
		a.put("iv", fIntValue);
}
/**
 * Set the integer value property.
 * Creation date: (08-30-99 4:08:25 PM)
 * @return boolean
 */
public void setInteger(boolean newIntValue) {
	fIntValue = newIntValue;
}
/**
 * Set the max property.
 * Creation date: (08-30-99 4:08:25 PM)
 * @return boolean
 */
public void setMax(double newMax) {
	fMax = newMax;
}
/**
 * Set the min property.
 * Creation date: (08-30-99 4:08:25 PM)
 * @return boolean
 */
public void setMin(double newMin) {
	fMin = newMin;
}
}
