package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.base.*;

/**
 * ULCproxy provides a default implementation for all remotable objects.
 */
public abstract class ULCProxy extends UlcObject implements Serializable, IProxy, ICallable, IDefaults {
	/*
	 * static initialization to set up Property Editors in the design environment.
	 */
	static {
		if (java.beans.Beans.isDesignTime())
			try {
			// So that we don't bring in stuff that's not needed at runtime,
			// we use the dynamic access methods instead of letting the
			// compiler do it.

			Class cls = Class.forName("java.beans.PropertyEditorManager");
			java.lang.reflect.Method getMthd = cls.getMethod("getEditorSearchPath", new Class[] {}), setMthd = cls.getMethod("setEditorSearchPath", new Class[] {String[].class});
			String[] currentPath = (String[]) getMthd.invoke(null, new Object[] {});
			int i;
			for (i = 0; i < currentPath.length; i++)
				
				// See if already in the path, if not, then it can be added.
				if (currentPath[i].equals("com.ibm.ulc.vaedit"))
					break;
			if (i >= currentPath.length) {
				// It needs to be added.
				String[] newPath = new String[currentPath.length + 1];
				for (i = 0; i < currentPath.length; i++)
					newPath[i] = currentPath[i];
				newPath[i] = "com.ibm.ulc.vaedit";
				setMthd.invoke(null, new Object[] {newPath});
			}
		} catch (Exception e) {
		};
	}
	/**
	 * The collection of listeners registered for actions in this widget.
	 * @serial
	 */
	protected UlcHashtable fListeners = null;
	/**
	 * The collection of children in this widget.
	 * @serial	 
	 */
	protected Vector fList = null;
	/**
	 * The unique identifier for this widget within one <code>ULCContext</code>.
	 * @serial	 
	 */
	private int fId = -1; // id for both ULC and UI registries
	/**
	 * The current connection timestamp identifier. If this does not match
	 * the actual identifier within the connection the widget is uploaded again to
	 * the UI.
	 * @serial	 
	 */
	private int fSeed = 0;
	/**
	 * The current context within which this widget is running.
	 * @serial	 
	 */
	protected ULCContext fContext = null;
	/**
	 * The list of optionalEvents that this widget should register for.
	 * @serial	 
	 */
	protected Hashtable fOptionalEvents = null;
/**
 * Default constructor for all <code>ULCProxy</code> objects.
 */
public ULCProxy() {
}
/**
 * Construct a <code>ULCProxy</code> on the specified <code>ULCContext</code>.
 *
 * @param context 	The <code>ULCContext</code> within which this proxyis active.
 */
public ULCProxy(ULCContext context) {
	fContext = context;
}
/**
 * Marshals the given object into an Anything.
 *
 * @param context 	The <code>ULCContext</code> within which this object is being marshalled.
 * @param o 		The <code>Object</code> which needs to be sent to the UI.
 * @return			The Anything that represents the object.
 */
public static Anything convert(ULCContext context, Object o) {
	if (o == null)
		return null;
	if (o instanceof IProxy) {
		IProxy p = (IProxy) o;
		return p.getRef(context);
	}
	Anything a = Common.convertToAnything(o);
	if (a != null)
		return a;
	trouble2("ULCProxy.convert(ULCContext,Object)", "cannot convert " + o.getClass().getName());
	return new Anything(o.toString());
}
/**
 * Unmarshals an Object from an Anything.
 *
 * @param a The Anything that desrcibes the object to be created.
 * @return 	The object that matches the description.
 */
protected Object convert(Anything a) {
	Object o = Common.convertFromAnything(a);
	if (o != null)
		return o;
	return a.asString(null);
}
/**
 * Deregister the specified eventName as an optionalEvent. Once registered
 * the UI will send this event when it occurs to the application.
 * If the event is not enabled then the UI might optimize the event and not send
 * it to the application.
 *
 * @param eventName The eventName <code>String</code> that needs to be enabled.
 */
protected void disableOptionalEvent(String eventName) {
	if (fOptionalEvents == null)
		return;
	Object value = fOptionalEvents.get(eventName);
	Integer count = new Integer(0);
	if (value != null)
		count = (Integer) value;
	if (count.intValue() == 0)
		fOptionalEvents.remove(eventName);
	else {
		fOptionalEvents.put(eventName, new Integer(count.intValue() - 1));
		return;
	}
	if (isUploaded())
		sendUI("setOptionalEvents", internalOptionalEventsAsAnything(fOptionalEvents));
}
/**
 * Distributes ULCEvents to listeners implementing the corresponding listener interface.
 *
 * @param event 	The event that will be distributed to all registered listeners.
 * @param eventKey 	The <code>String</code> key of the event.
 */
protected void distributeToListeners(String eventKey, ULCEvent event) {
	if (fListeners != null) {
		Object value = fListeners.get(eventKey);
		if (value == null)
			return;
		Vector list = (Vector) value;
		Enumeration e = list.elements();
		while (e.hasMoreElements()) {
			IListener listener = (IListener) e.nextElement();
			if (listener != null)
				event.dispatch(listener);
		}
	}
}
/**
 * Register the specified eventName as an optionalEvent. Once registered
 * the UI will send this event when it occurs to the application.
 * If the event is not enabled then the UI might optimize the event and not send
 * it to the application.
 *
 * @param eventName The eventName <code>String</code> that needs to be enabled.
 */
protected void enableOptionalEvent(String eventName) {
	if (fOptionalEvents == null)
		fOptionalEvents = new Hashtable();
	Object value = fOptionalEvents.get(eventName);
	Integer count = new Integer(0);
	if (value != null)
		count = (Integer) value;
	fOptionalEvents.put(eventName, new Integer(count.intValue() + 1));
	if (isUploaded() && (count.intValue() == 0))
		sendUI("setOptionalEvents", internalOptionalEventsAsAnything(fOptionalEvents));
}
/**
 * This widget is being destroyed perform any cleanUp necessary.
 */
public void free() {
	if (fListeners != null)
		fListeners.clear();
	if (fList != null) {
		for (int i = 0; i < fList.size(); i++) {
			ULCProxy p = (ULCProxy) fList.elementAt(i);
			p.free();
		}
		fList.removeAllElements();
	}
	if (fContext != null) {
		fContext.unregister(this);
		fContext = null;
	}
}
/**
 * Returns the <code>ULCContext</code> within which the widget is active.
 *
 * @return The <code>ULCContext</code> within which the widget is active.
 */
public ULCContext getContext() {
	Assert.isNotNull(fContext);
	return fContext;
}
/**
 * Creates a unique (within ULC) id for this object and registers
 * it in the registry.
 *
 * @return the <code>int</code> value that uniquely identifies this widget.
 */
public int getId() {
	if (fId < 0) {
		Assert.isNotNull(fContext);
		fId = fContext.register(this);
	}
	return fId;
}
/**
 * Creates an Anything that can be used inside UI to find
 * or construct the UI peer.
 * If the object has been uploaded a ref is just the registry id.
 * Otherwise the (deep) state of the object is dumped into
 * an Anything which can be used as an argument to the "new" call.
 *
 * @param	context The <code>ULCContext</code> within which this widget is active.
 * @return The Anything that fully describes or references this widget.
 */
public Anything getRef(ULCContext context) {
	if (context != null)
		fContext = context;
	Assert.isNotNull(fContext);
	Anything a;
	if (isUploaded()) {
		a = new Anything();
		a.put("oid",getId());
	}
	else {
		fSeed = fContext.getSeed();
		a = new Anything();
		a.put("type", ""); // ensure type slot is first
		a.put("oid", 0); // ensure oid slot is second
		saveState(a);
		// verify that there is a classname for the UI half
		if (a.get("type", "").equals("")) {
			// otherwise generate one
			String typeName = typeString();
			if (typeName != null)
				a.put("type", typeName);
		}
	}
	return a;
}
/**
 * The UI has sent a request to this object. Do all processing necessary.
 * If the call chain has reached this object it means that the request is an unknown request.
 * Write the received request to the console.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("event")) {
		String type = args.get("type", "???");
		System.out.print("Event: " + type + " ");
		args.dump(System.out);
		return;
	}
}
/**
 * Adds the  <code>IProxy</code> to the list of children for this widget.
 *
 * @param c An <code>IProxy</code>
 */
protected void internalAdd(IProxy c) {
	if (fList == null)
		fList = new Vector();
	if (!fList.contains(c)) {
		fList.addElement(c);
		sendUI("add", c);
	}
}
/**
 * Adds the collection of <code>IProxy's</code> to the list of children for this widget.
 *
 * @param proxies A <code>Vector</code> containing <code>IProxy's</code>
 */
protected void internalAdd(Vector proxies) {
	if (fList == null)
		fList = new Vector();
	Anything a = new Anything();
	Enumeration e = proxies.elements();
	while (e.hasMoreElements()) {
		Object o = e.nextElement();
		if (o instanceof IProxy) {
			IProxy c = (IProxy) o;
			fList.addElement(c);
			if (fContext != null)
				a.append(c.getRef(fContext));
		}
	}
	if (fContext != null)
		sendUI("addMany", a);
}
/**
 * Registers the given listener to my list of active listeners
 * if the listener is not already registered.
 *
 * @param listener	The object interested in one of my events.
 * @param key		The <code>String</code> key at which the listener should be added.
 */
protected synchronized void internalAddListener(String key, IListener listener) {
	if (fListeners == null)
		fListeners = new UlcHashtable();
	Object value = fListeners.get(key);
	Vector list = null;
	if (value != null)
		list = (Vector) value;
	if (list == null) {
		list = new Vector();
		fListeners.put(key, list);
	}
	list.addElement(listener);
}
/**
 * Convenience method to convert a Color object to the Anything format
 **/
protected Anything internalConvertColor(Color color) {
	Anything a = new Anything();
	a.put("r", color.getRed());
	a.put("g", color.getGreen());
	a.put("b", color.getBlue());
	return a;
}
/**
 * Returns a <code>Vector</code> list of my children.
 *
 * @return The <code>Vector</code> list of my children.
 */
protected Vector internalGetComponents() {
	if (fList == null)
		fList = new Vector();
	return fList;
}
/**
 * Inserts the  <code>IProxy</code> to the list of children for this widget at the specified position.
 *
 * @param c		 	An <code>IProxy</code>
 * @param position	An <code>int</code> index into the collection.
 */
protected void internalInsert(IProxy c, int position) {
	if (fList == null)
		fList = new Vector();
	fList.insertElementAt(c, position);
	Anything a = new Anything();
	if (isUploaded()) {
		a.put("c", c.getRef(fContext));
		a.put("pos", position);
		sendUI("insert", a);
	}
}
private Anything internalOptionalEventsAsAnything(Hashtable optionalEvents) {
	Anything list = new Anything();
	Enumeration e = optionalEvents.keys();
	while (e.hasMoreElements()) {
		String s = (String) e.nextElement();
		list.append(new Anything(s));
	}
	return list;
}
/**
 * Removes <code>IProxy</code> from the list of my children.
 *
 * @param c The <code>IProxy</code> that should be removed from the list of my children.
 */
protected void internalRemove(IProxy c) {
	if (fList != null) {
		fList.removeElement(c);
		sendUI("remove", c);
	}
}
/**
 * Removes all <code>IProxy's</code> within the list of my children.
 *
 * @param proxies The <code>Vector</code> list of my chldren that should be removed.
 */
protected void internalRemove(Vector proxies) {
	if (fList != null) {
		Anything a = new Anything();
		Enumeration e = proxies.elements();
		while (e.hasMoreElements()) {
			Object o = e.nextElement();
			if (o instanceof IProxy) {
				IProxy c = (IProxy) o;
				fList.removeElement(c);
				if (fContext != null)
					a.append(c.getRef(fContext));
			}
		}
		if (fContext != null)
			sendUI("removeMany", a);
	}
}
/**
 * DeRegisters the given listener from my list of active listeners
 *
 * @param listener	The object that was interested in one of my events.
 * @param key		The key at which the listener is registered.
 */
protected synchronized void internalRemoveListener(String key, IListener listener) {
	if (fListeners == null)
		return;
	Object value = fListeners.get(key);
	if (value == null)
		return;
	Vector list = (Vector) value;
	list.removeElement(listener);
}
/**
 * Returns true if the eventName specified is currently enabled.
 *
 * @param eventName	The <code>String</code> name of the event that should be tested.
 */
public boolean isOptionalEventEnabled(String eventName) {
	if (fOptionalEvents == null)
		return false;
	return fOptionalEvents.containsKey(eventName);
}
/**
 * Returns true if this object was already uploaded to the UI.
 * We ask ULC whether our seed is recent.
 *
 * @return if false, the object needs to be uploaded.
 */
public boolean isUploaded() {
	return fContext != null && fContext.isRecent(fSeed);
}
/**
 * Release all the resources of the receiver, 
 * including the resources on the UI side.
 *
 * Warning: 
 *	It is the responsibility of the developer 
 *  to ensure that when this method is called the 
 *	application no longer references or uses this 
 *  proxy both on the UI and ULC side.
 *	
 */
public void release() {
	sendUI("release");
	free();
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	a.put("oid", new Anything(getId()));
	if (fList != null && fList.size() > 0) {
		Anything l = new Anything();
		Enumeration e = fList.elements();
		while (e.hasMoreElements()) {
			IProxy c = (IProxy) e.nextElement();
			l.append(c.getRef(fContext));
		}
		a.put("list", l);
	}
	if (fOptionalEvents != null) {
		a.put("oe", internalOptionalEventsAsAnything(fOptionalEvents));
	}
}
/**
 * Send the request to the UI.
 *
 * @param request The <code>String</code> name of the request.
 */
public void sendUI(String request) {
	if (isUploaded())
		fContext.send(getId(), request, null);
}
/**
 * Send the request to the <code>IProxy</code> in the UI.
 *
 * @param request 	The <code>String</code> name of the request.
 * @param proxy 	The <code>IProxy</code> target for this request.
 */
public void sendUI(String request, IProxy proxy) {
	if (isUploaded())
		fContext.send(getId(), request, proxy.getRef(fContext));
}
/**
 * Send the request with the specified arguments to my proxy object in the UI.
 *
 * @param request 	The <code>String</code> name of the request.
 * @param args		The Anything that contains all the arguments for this request.
 */
public void sendUI(String request, Anything args) {
	if (isUploaded())
		fContext.send(getId(), request, args);
}
/**
 * returns a logical name for this component.
 * This name is used to locate the other half of this object in the UI Engine.
 * The default implementation extracts the name from the class name by stripping
 * off the package name and an optional prefix "ULC".
 * widgets that are not found in the com.ibm.ulc.ui.swing package should
 * override this method to return the fully qualified class name of the UI class
 * eg: com.ibm.ulc.ui.UIApplication
 *
 * @return The Logical name for this component.
 */
protected String typeString() {
	Class cl = getClass();
	String name = cl.getName();
	String prefix = "ULC";

	// find class name in package path
	int pos = name.lastIndexOf('.');
	if (pos >= 0)
		name = name.substring(pos + 1);

	// strip off prefix
	if (name.startsWith(prefix))
		return name.substring(prefix.length());
	trouble("getRef", "couldn't create UI class name for " + cl.getName());
	return null;
}
/**
 * Upload self and all referenced objects (if necessary) to the UI.
 *
 * @param context The <code>ULCContext</code> within which this widget is active.
 */
public void upload(ULCContext context) {
	if (context != null)
		fContext = context;
	if (!isUploaded())
		fContext.create(getRef(fContext));
}
}
