package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;

/**
 * This widget is usually associated with an ULCField or ULCLabel.
 * It is used for ensuring that the input in this field is a
 * percentage value. The receiver also
 * adds a "%" at the end of the input, if it is a valid entry.
 */
public class ULCPercentValidator extends ULCProxy implements IDataType {
	/**
	 * The number of digits after the decimal point. default is 2.
	 * @serial	 
	 */
	protected int fFractDigits = 2;
	/**
	 * Creates a new ULCPercentValidator with 2 fractional digits.
	 */
	public ULCPercentValidator() {
	}
/**
 * Creates a new ULCPercentValidator withe the specified number of fractional digits.
 *
 * @param fractDigits	The number of fractional digits allowed.
 */
public ULCPercentValidator(int fractDigits) {
	fFractDigits = fractDigits;
}
/**
 * Answers the fractional Digits property.
 * Creation date: (08-30-99 4:05:31 PM)
 * @return int
 */
public int getFractionalDigits() {
	return fFractDigits;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fFractDigits != 2)
		a.put("fracts", fFractDigits);
}
/**
 * Sets the fractional Digits property.
 * Creation date: (08-30-99 4:05:31 PM)
 * @return int
 */
public void setFractionalDigits(int newFracDigits) {
	fFractDigits = newFracDigits;
}
}
