package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/** 
 * An event that characterizes a change in the current selection.
 * @see IPageChangedListener
 */
public class ULCPageChangedEvent extends ULCEvent {
	/** 
	 * The label of the current pagebook page.
	 * @serial
	 */
	protected String fPage = null;
/**
 * (c) Object Technology International 1997,1998.
 * @param source java.lang.Object
 * @param pageLabel java.lang.String
 */
public ULCPageChangedEvent(Object source, String pageLabel) {
	super(source);
	fPage= pageLabel;
}
	/**
 * Dispatch this event to the specified object if it implements the IPageChangedListener interface.
 *
 * @param listener the <code>IPageChangedListener</code> that is interested in this event.
 */
public void dispatch(IListener listener) {
	if (listener instanceof IPageChangedListener) {
		IPageChangedListener sl = (IPageChangedListener) listener;
		sl.pageChanged(this);
	}
}
/**
 * Returns the event's current page label
 *
 * @return The <code>String</code> page label
 */
public String getPage() {
	return fPage;
}
}
