package com.ibm.ulc.application;

import java.awt.Color;
import com.ibm.ulc.util.*;
/**
 * An And Enabler that also marks all source widgets as needing input if they have no input.
 */
public class ULCMandatoryAndEnabler extends ULCAndEnabler {
	protected int fMandatoryStyle = MANDATORY_STYLE_BACKGROUND;
	protected Color fHighLightColor = null;
/**
 * Create a ULCMandatoryAndEnabler with the style MANDATORY_STYLE_BACKGROUND.
 */
public ULCMandatoryAndEnabler() {
	super();
}
/**
 * Gets the highlight color for this widget or null if not specified.
 *
 * @return The <code>Color</code> that is used within this widget
 */
public Color getHighLightColor() {
	return fHighLightColor;
}
/**
 * Gets the Mandatory Style type of this widget.
 * <pre>
 * The style can be one of:
 * 		MANDATORY_STYLE_BACKGROUND
 *		MANDATORY_STYLE_BORDERED
 * </pre>
 *
 * @return The <code>int</code> style that is used within this widget
 */
public int getMandatoryStyle() {
	return fMandatoryStyle;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fHighLightColor != null)
		a.put("bc", internalConvertColor(fHighLightColor));
	if (fMandatoryStyle != MANDATORY_STYLE_BACKGROUND)
		a.put("style", fMandatoryStyle);
}
/**
 * Sets the highlight color for this widget or null if not specified.
 *
 * @return The <code>Color</code> that is used within this widget
 */
public void setHighLightColor(Color highLightColor) {
	fHighLightColor = highLightColor;
}
/**
 * Sets the Mandatory Style type of this widget.
 * <pre>
 * The style can be one of:
 * 		MANDATORY_STYLE_BACKGROUND
 *		MANDATORY_STYLE_BORDERED
 * </pre>
 *
 * @param int style	One of the valid style values
 */
public void setMandatoryStyle(int style) {
	fMandatoryStyle = style;
}
}
