package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;
import java.util.Vector;

/**
 * The ULCList displays a collection of objects in the form of a scrollable
 * list and allows the user to select from.
 * The list of items is specified via a ULCTableModel.
 */
public class ULCList extends ULCTableList implements IEnabler {
	/**
	 * The attribute key to be used when requesting the data from the ULCTableModel.
	 * @serial	 	 
	 */
	protected String fColId = null;
	/**
	 * The component to be used for rendering the receiver widget.
	 * @serial	 
	 */
	protected ULCComponent fRenderer = null;
/**
 * Constructs a new ULCList
 */
public ULCList() {
}
/**
 * Constructs a new ULCList which displays values from the specified ULCTableModel.
 *
 * @param tableModel	The <code>ULCAbstractTableModel</code> that will serve as the data source.
 * @param width 		Width of the ScrollPanes content area in pixels.
 * @param heightInRows 	Height of the ScrollPanes content area in full rows.
 */
public ULCList(ULCAbstractTableModel tableModel, int width, int heightInRows) {
	super(tableModel, width, heightInRows);
}
/**
 * Constructs a new ULCList which displays values from the specified column of the given ULCTableModel.
 *
 * @param tableModel	The <code>ULCAbstractTableModel</code> that will serve as the data source.
 * @param attributeName	The attribute key to be used when requesting data from the <code>ULCAbstractTableModel</code>.
 * @param width 		Width of the ScrollPanes content area in pixels.
 * @param heightInRows 	Height of the ScrollPanes content area in full rows.
 */
public ULCList(ULCAbstractTableModel tableModel, String attributeName, int width, int heightInRows) {
	super(tableModel, width, heightInRows);
	fColId = attributeName;
}
/**
 * Constructs a new ULCList which displays values from the specified column of the given ULCTableModel.
 *
 * @param tableModel	The <code>ULCAbstractTableModel</code> that will serve as the data source.
 * @param attributeName	The attribute key to be used when requesting data from the <code>ULCAbstractTableModel</code>.
 * @param renderer 		ULCComponent to use as a renderer for the ULCAbstractTableModel's values..
 * @param width 		Width of the ScrollPanes content area in pixels.
 * @param heightInRows 	Height of the ScrollPanes content area in full rows.
 */
public ULCList(ULCAbstractTableModel tableModel, String attributeName, ULCComponent renderer, int width, int heightInRows) {
	super(tableModel, width, heightInRows);
	fRenderer = renderer;
	fColId = attributeName;
}
/**
 * Constructs a new ULCList which displays values from the specified column of the given ULCAbstractTableModel.
 *
 * @param tableModel	The <code>ULCAbstractTableModel</code> that will serve as the data source.
 * @param attributeName	The attribute key to be used when requesting data from the <code>ULCAbstractTableModel</code>.
 * @param renderer 		ULCComponent to use as a renderer for the ULCTableModel's values..
 * @param width 		Width of the ScrollPanes content area in pixels.
 * @param heightInRows 	Height of the ScrollPanes content area in full rows.
 * @param selectionMode	The selection mode which can be one of:
 * <pre>
 *  					IDefaults.LIST_SINGLE_SELECTION
 *  					IDefaults.LIST_SINGLE_INTERVAL_SELECTION
 *  					IDefaults.LIST_MULTIPLE_INTERVAL_SELECTION
 * </pre>

 */
public ULCList(ULCAbstractTableModel tableModel, String attributeName, ULCComponent renderer, int width, int heightInRows, int selectionMode) {
	super(tableModel, width, heightInRows, selectionMode);
	fRenderer = renderer;
	fColId = attributeName;
}
/**
 * Add all table attributes that should be preloaded to the UI to the specified Vector.
 *
 * @param vectorOfPreloadAttributes	Vector	into which the receiver adds the
 *					table attributes it needs to preload.
 *
 */
public void addPreloadTableAttributesInto(Vector vectorOfPreloadAttributes) {
	if (!vectorOfPreloadAttributes.contains(getAttributeName())) {
		vectorOfPreloadAttributes.addElement(getAttributeName());
	}
}
/**
 * Gets the attributeName which is used as a key to query values from 
 * the ULCTableModel of this widget.
 *
 * @return	The <code>String</code> to be used as a key
 */
public String getAttributeName() {
	return fColId;
}
/**
 * Gets the renderer of this widget
 *
 * @return	The <code>ULCComponent</code> to be used as the renderer
 */
public ULCComponent getRenderer() {
	return fRenderer;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	if (fRenderer != null)
		a.put("renderer", fRenderer.getRef(fContext));
	super.saveState(a);
	if (fColId != null)
		a.put("colId", fColId);
}
/**
 * Sets the attributeName which is used as a key to query values from 
 * the ULCTableModel of this widget.
 * Setting this value after the widget has been uploaded has no effect.
 *
 * @return	The <code>String</code> to be used as a key
 */
public void setAttributeName(String attributeName) {
	fColId = attributeName;
}
/**
 * Set the renderer of this widget
 * Setting this value after the widget has been uploaded has no effect.
 *
 * @param renderer	The <code>ULCComponent</code> to be used as the renderer
 */
public void setRenderer(ULCComponent renderer) {
	fRenderer = renderer;
}
/**
 * returns the fully qualified class name of my UI class
 */
protected String typeString() {
	return "List";
}
}
