package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * Implements the event that is sent when a hyperlink is activated in an ULCHtmlPane.
 *
 * @see ULCHtmlPane
 * @see ULCHtmlPane#addLinkActivatedListener
 */
public class ULCLinkActivatedEvent extends ULCEvent {
	/**
	 * The URL of the link that was activated.
	 * @serial	 	 
	 */
	protected String fUrl = null;
/**
 * Contruct an ULCLinkActivatedEvent with the specified source and URL as a string.
 *
 * @param source 	The <code>Object</code> that generated this event.
 * @param urlString	The URL as a <code>String</code> of the activated link.
 */
ULCLinkActivatedEvent(Object source, String urlString) {
	super(source);
	fUrl = urlString;
}
/**
 * Dispatch this event to the specified object if it implements the IHyperLinkListener interface.
 *
 * @param listener	The object interested in my link activation events.
 */
public void dispatch(IListener listener) {
	if (listener instanceof IHyperLinkListener) {
		IHyperLinkListener l = (IHyperLinkListener) listener;
		l.linkActivated(this);
	}
}
/**
 * Return my URL string
 *
 * @return The URL as a <code>String </code>.
 */
public String getUrlString() {
	return fUrl;
}
}
