package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;
import com.ibm.ulc.base.IDefaults;

/**
 * A display area for a short text string or an image, or both.
 * The current value is either determined by the fLabel and fIcon field of this widget or
 * by an attribute of a ULCFormModel.
 * A DataType object can be specified to allow for displaying of non String or Icon objects.
 * In this case the ULCLabel label is converted into a String by means of the DataType object.
 */
public class ULCLabel extends ULCFormComponent implements IContainerItem {
	/**
	 * The optional ULCIcon to be displayed
	 * @serial	 
	 */
	protected ULCIcon fIcon = null;
	/**
	 * The optional ULCDatatype object to be used for converting/formatting my label string.
	 * @serial	 	 
	 */
	protected IDataType fDataType = null;
	/**
	 * The current horizontal text alignment
	 * @serial	 	 
	 */
	protected int fHorizontalAlignment = BOX_LEFT;
	/**
	 * The current vertical text alignment
	 * @serial	 	 
	 */
	protected int fVerticalAlignment = BOX_CENTER;
	/**
	 * The current horizontal text position relative to its image
	 * @serial	 	 
	 */
	protected int fHorizontalTextPosition = BOX_RIGHT;
/**
 * Constructs an empty ULCLabel.
 */
public ULCLabel() {
}
/**
 * Constructs a ULCLabel which tracks the state of the specified attribute of the given FormModel.
 *
 * @param formModel The <code>ULCFormModel</code> whose state the label should track.
 * @param formAttributeName 	The attribute key of the <code>ULCFormModel</code> whose value the label should track.
 */
public ULCLabel(IForm formModel, String formAttributeName) {
	super(formModel, formAttributeName);
}
/**
 * Constructs a ULCLabel which tracks the state of the specified attribute of the given FormModel.
 * The value of the attribute is formatted by using the given DataType.
 *
 * @param formModel 		The <code>ULCFormModel</code> whose state the label should track.
 * @param formAttributeName	The attribute key of the <code>ULCFormModel</code> whose value the label should track.
 * @param 	dataType
 *			The object that will perform validation/conversion on the label <code>String</code>.
 */
public ULCLabel(IForm formModel, String formAttributeName, IDataType dataType) {
	super(formModel, formAttributeName);
	fDataType = dataType;
}
/**
 * Constructs a new ULCLabel with the initial text label and the given font.
 *
 * @param font 	The <code>ULCFont</code> to be used for my label.
 * @param label	The <code>String</code> value for my displayable text.
 */
public ULCLabel(ULCFont font, String label) {
	super(label);
	fFont = font;
}
/**
 * Constructs a new ULCLabel with the initial icon. 
 *
 * @param icon 	The <code>ULCIcon</code> to be displayed.
 */
public ULCLabel(ULCIcon icon) {
	fIcon = icon;
}
/**
 * Constructs a new ULCLabel with the initial text label. 
 *
 * @param label 	The <code>String</code> value to be displayed.
 */
public ULCLabel(String label) {
	super(label);
}
/**
 * Answers the data type property.
 * Creation date: (08-30-99 5:13:13 PM)
 * @return com.ibm.ulc.application.IDataType
 */
public IDataType getDataType() {
	return fDataType;
}
/**
 * Returns the alignment of the label's contents along the X axis.
 * <p>
 *
 * @return alignment  One of the following constants
 *           defined in <code>IDefaults</code>:
 *           <code>BOX_LEFT</code> (the default for text-only labels),
 *           <code>BOX_CENTER</code> (the default for image-only labels), or
 *           <code>BOX_RIGHT</code>.
 *
 * @see IDefaults 
 */
public int getHorizontalAlignment() {
	return fHorizontalAlignment;
}
/**
 * Gets the position of the text relative to the labels image.
 * <p>
 *
 * @param alignment  One of the following constants
 *           defined in <code>IDefaults</code>:
 *           <code>BOX_LEFT</code> ,
 *           <code>BOX_CENTER</code>,
 *           <code>BOX_RIGHT</code>(the default for text-only labels).
 *
 * @see IDefaults 
 */

public int getHorizontalTextPosition() {
	return fHorizontalTextPosition;
}
/**
 * Return the icon of the button.
 *
 * @return The ULCIcon to be displayed.
 */
public ULCIcon getIcon() {
	return fIcon;
}
/**
 * Gets the label's text.
 *
 * @return The current label <code>String</code> value
 */
public String getLabel() {
	return fLabel;
}
/**
 * Returns the alignment of the label's contents along the Y axis.  
 * <p>
 * The default value of this property is BOX_CENTER.
 * <p>
 * 
 * @return alignment One of the following constants
 *           defined in <code>IDefaults</code>:
 *           <code>BOX_TOP</code>,
 *           <code>BOX_CENTER</code> (the default), or
 *           <code>BOX_BOTTOM</code>.
 *
 */
public int getVerticalAlignment() {
	return fVerticalAlignment;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fIcon != null)
		a.put("icon", fIcon.getRef(fContext));
	if (fDataType != null)
		a.put("dataType", fDataType.getRef(fContext));
	if (fHorizontalAlignment != BOX_LEFT)
		a.put("ha", new Anything(fHorizontalAlignment));
	if (fVerticalAlignment != BOX_CENTER)
		a.put("va", new Anything(fVerticalAlignment));
	if (fHorizontalTextPosition != BOX_RIGHT)
		a.put("htp", new Anything(fHorizontalTextPosition));
}
/**
 * Sets the data type property.
 * Creation date: (08-30-99 5:13:13 PM)
 * @return com.ibm.ulc.application.IDataType
 */
public void setDataType(IDataType newDataType) {
	fDataType = newDataType;
}
/**
 * Sets the alignment of the label's contents along the X axis.
 * <p>
 *
 * @param alignment  One of the following constants
 *           defined in <code>IDefaults</code>:
 *           <code>BOX_LEFT</code> (the default for text-only labels),
 *           <code>BOX_CENTER</code> (the default for image-only labels), or
 *           <code>BOX_RIGHT</code>.
 *
 * @see IDefaults 
 */
public void setHorizontalAlignment(int horizontalAlignment) {
	if (horizontalAlignment != fHorizontalAlignment) {
		fHorizontalAlignment = horizontalAlignment;
		sendUI("setHorizontalAlignment", new Anything(fHorizontalAlignment));
	}
}
/**
 * Sets the position of the text relative to the labels image.
 * <p>
 *
 * @param alignment  One of the following constants
 *           defined in <code>IDefaults</code>:
 *           <code>BOX_LEFT</code> ,
 *           <code>BOX_CENTER</code>,
 *           <code>BOX_RIGHT</code>(the default for text-only labels).
 *
 * @see IDefaults 
 */

public void setHorizontalTextPosition(int x) {
	fHorizontalTextPosition = x;
}
/**
 * Set the icon of the button.
 *
 * @param icon The ULCIcon to be displayed.
 */
public void setIcon(ULCIcon icon) {
	if (icon != fIcon) {
		fIcon = icon;
		if (fIcon != null)
			sendUI("setIcon", fIcon);
		else
			sendUI("setIcon", new Anything());
	}
}
/**
 * Sets the widgets's <code>String</code> label.
 *
 * @param label the label <code>String</code> of the widget.
 */
public void setLabel(String label) {
	internalSetLabel(label);
}
/**
 * Sets the alignment of the label's contents along the Y axis.  
 * <p>
 * The default value of this property is BOX_CENTER.
 * <p>
 * 
 * @param alignment One of the following constants
 *           defined in <code>IDefaults</code>:
 *           <code>BOX_TOP</code>,
 *           <code>BOX_CENTER</code> (the default), or
 *           <code>BOX_BOTTOM</code>.
 *
 */
public void setVerticalAlignment(int verticalAlignment) {
	if (verticalAlignment != fVerticalAlignment) {
		fVerticalAlignment = verticalAlignment;
		sendUI("setHorizontalAlignment", new Anything(fVerticalAlignment));
	}
}
}
