package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.ORBConnection;
import java.io.*;
import java.net.*;

/**
 * Provides support for images to be be displayed on the UI. 
 * The icon instantiation typically happens using the resource-
 * handling process, which is used for locating the 'gif' file
 * on the application side.
 *
 * @see Class#getResource(String)
 */
public class ULCIcon extends ULCProxy {
	/**
	 * The URL used to retrieve the icon resource.
	 * @serial	 
	 */
	protected URL fURL = null;
	protected boolean fCachedOnUI = false;
	protected String fResourceTimestamp = "None";
	protected int fResourceSize = 0;
/**
 * Constructs a new ULCIcon from the specified URL.
 *
 * @param url The URL where the images's data can be located.
 */
public ULCIcon(URL url) {
	fURL = url;
}
/**
 * Constructs a new ULCIcon from the specified URL.
 *
 * @param url The URL where the images's data can be located.
 */
public ULCIcon(URL url, boolean cached) {
	fURL = url;
	fCachedOnUI = cached;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
protected void fillCacheInformation(Anything any) {
	any.put("hn", getLocalHostAddress());
	any.put("an", getApplicationName());
	any.put("ps", getShortPathString(getPathString()));
	any.put("fts", getResourceTimestamp());
	any.put("fsz", getResourceSize());
}
protected String getApplicationName() {
	return getContext().getClass().getName();
}
/**
 * Load the image from the specified url and return it as an array of bytes.
 */
protected byte[] getIconData() {
	InputStream stream = null;
	if (fURL != null) {
		try {
			stream = fURL.openStream();
		} catch (IOException e) {
			trouble("getIconData", "URL " + fURL + " not found");
		}
	} else {
		trouble("getIconData", "fURL is null");
	}
	if (stream == null)
		return null;
	try {
		ByteArrayOutputStream data = new ByteArrayOutputStream();
		int b = 0;
		while ((b = stream.read()) != -1)
			data.write(b);
		stream.close();
		data.close();
		return data.toByteArray();
	} catch (IOException e) {
		trouble("getIconData", "IOException while reading " + fURL);
	}
	return null;
}
/**
 * Get the local Host address as a raw IP address in a string format.
 * If an exception occurs the default string of 127.0.0.1 is returned.
 */
protected String getLocalHostAddress() {
	try {
		return InetAddress.getLocalHost().getHostAddress();
	} catch (UnknownHostException e) {
		return "127.0.0.1";
	}
}
protected String getPathString() {
	return fURL.getFile();
}
protected int getResourceSize() {
	return getIconData().length;
}
protected String getResourceTimestamp() {
	return "";
}
protected static String getShortPathString(String path) {
	int index = path.lastIndexOf('/');
	if (index >= 0)
		return path.substring(index + 1, path.length());
	return path;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("getCacheData")) {
		setCacheData();
		return;
	};
	super.handleRequest(conn, request, args);
}
/**
 * answer true, if the receiver is expected to be cached on the UI
 */
public boolean isCachedOnUI() {
	return fCachedOnUI;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (isCachedOnUI()) {
		Anything cacheInfo = new Anything();
		try {
			fillCacheInformation(cacheInfo);
		} catch (Exception e) {
			cacheInfo = null;
			setCachedOnUI(false);
		}
		if (cacheInfo != null)
			a.put("ci", cacheInfo);
	} else {
		byte[] data = getIconData();
		if (data != null)
			a.put("icon", data);
	};
}
protected void setCacheData() {
	Anything any = new Anything();
	byte[] data = getIconData();
	if (data != null)
		any.put("icon", data);
	fillCacheInformation(any);
	sendUI("setCacheData", any);
}
/**
 * Set cached to true, if the receiver is expected to be cached on the UI
 */
public void setCachedOnUI(boolean cached) {
	fCachedOnUI = cached;
}
protected void setResourceSize(int i) {
	fResourceSize = i;
}
protected void setResourceTimestamp(String timestamp) {
	fResourceTimestamp = timestamp;
}
/**
 * returns a logical name for this component.
 * This name is used to locate the other half of this object in the UI Engine.
 * The default implementation extracts the name from the class name by stripping
 * off the package name and an optional prefix "ULC".
 * widgets that are not found in the com.ibm.ulc.ui.swing package should
 * override this method to return the fully qualified class name of the UI class
 * eg: com.ibm.ulc.ui.UIApplication
 *
 * @return The Logical name for this component.
 */
protected String typeString() {
	if (isCachedOnUI()) {
		return "CachedIcon";
	}
	else {
		return super.typeString();
	};
}
}
