package com.ibm.ulc.application;

/**
 * Insert the type's description here.
 * Creation date: (10/25/99 6:59:05 PM)
 * @author: Stefan Bosshard, OTI
 */
import com.ibm.ulc.util.UlcHashtable;
public class ULCHierarchicalRowCache extends ULCAbstractRowCache implements IRowCache {
	private IHierarchicalTableModel fHierarchicalModel;
	private UlcHashtable fOidToRow = new UlcHashtable();
	private UlcHashtable fRowToOid = new UlcHashtable();
/**
 * Create an instance of the receiver with the specified tableModel.
 *
 */
public ULCHierarchicalRowCache(ULCAbstractTableModel model) {
	this(model, (IHierarchicalTableModel) model);
}
/**
 * Create an instance of the receiver with the specified tableModel.
 *
 */
public ULCHierarchicalRowCache(ULCAbstractTableModel model, IHierarchicalTableModel hierarchicalTableModel) {
	super(model);
	fHierarchicalModel = hierarchicalTableModel;
}
/**
 * Calling this API will force all rows of the receiver's tableModel to be identified by a unique oid.
 * This implementation does not touch the database. When itemlists of the receiver's model need the
 * oid for a given row, they must get it using the receiver's #getRowIdFor API.
 *
 * @see #getRowIdFor
 */
public int[] getAllRowIds() {
	trouble("ULCHierarchicalRowCache", "Accessing all rowIds: probably should not do that here");
	return getModel().getItemList().getObjectIdentifiers(0, getRowCount());
}
/**
 * getRowAtRowId method comment.
 */
UlcCachedRow getCachedRow(int rowId) {
	Object answer = fOidToRow.get(new Integer(rowId));
	if (answer == null) {
		UlcCachedRow row = newCachedRow(null);
		fOidToRow.put(new Integer(rowId), row);
		return row;
	}
	else
		return (UlcCachedRow) answer;
}
/**
 * Answer the general tableModel interface of the receiver's model
 */
protected IHierarchicalTableModel getHierarchicalModel() {
	return fHierarchicalModel;
}
/**
 * Answer the application object defined by <code>rowId</code>. Answer null, if the object was not found.
 *
 * @param rowId	The identfier of the row being accessed.
 */
public java.lang.Object getRowAtRowId(int rowId) {
	if (rowId < 0)
		return null;
	UlcCachedRow cachedRow = getCachedRow(rowId);
	if (cachedRow.getObject() == null)
		trouble("ULCHierarchicalRowCache", "missing row for known rowId: should not happen");
	return cachedRow.getObject();
}
/**
 * Answer the current rowId for the specified object. Answer -1, if the id is not defined.
 */
public int getRowIdFor(java.lang.Object object) {
	if (object == null)
		return getInvalidOid();
	Object answer = fRowToOid.get(object);
	if (answer == null) {
		int oid = getNextOid();
		setRowIdFor(oid, object);
		return oid;
	}
	else
		return ((Integer) answer).intValue();
}
/**
 * The specified oid was assigned for object. Add the mapping to the receiver.
 */
public void resetRowId(int oid) {
	Integer key = new Integer(oid);
	if (fOidToRow.containsKey(key)) {
		fRowToOid.remove(getRowAtRowId(oid));
		fOidToRow.remove(key);
	}
}
/**
 * The specified oid was assigned for object. Add the mapping to the receiver.
 */
public void setRowIdFor(int oid, Object object) {
	super.setRowIdFor(oid, object);
	if (object != null)
		fRowToOid.put(object, new Integer(oid));
}
}
