package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.*;
import java.io.*;
import java.awt.GraphicsEnvironment;

/**
 * Representation of ULC font objects.
 */
public class ULCFont extends ULCProxy {
	/** 
	 * The default font style constant. 
	 * This can be combined with the other style constants for mixed styles.
	 * @serial	 
	 */
	public static final int PLAIN = 0;
	/** 
	 * The bold style constant. 
	 * This can be combined with the other style constants for mixed styles.
	 * @serial	 
	 */
	public static final int BOLD = 1;
	/**
	 * The italicized style constant.  
	 * This can be combined with the other style constants for mixed styles.
	 * @serial	 
	 */
	public static final int ITALIC = 2;
	/** 
	 * The name of the font
	 * @serial	 
	 */
	protected String fName = null;
	/** 
	 * The point size of the font
	 * @serial	 
	 */
	protected int fSize = 10;
	/** 
	 * The current style which is a combination of the style constants.
	 * @serial	 
	 */
	protected int fStyle = PLAIN;
/**
 * Constructs a default ULCFont
 * 
 */
public ULCFont() {
	this("Serif", PLAIN, 10);
}
/**
 * Constructs an object which represents a font with the given name, style, and size.
 * 
 * @param name 	The name of the font
 * @param style The style which is a combination of the style constants.
 * @param size 	The point size of the font
 */
public ULCFont(String name, int style, int size) {
	fName = name;
	fStyle = style;
	fSize = size;
}
/**
 * Return the list of default font names. 
 * This method should not be called on environments that do not have
 * a display setup.
 * 
 */
public static String[] getDefaultFontNames() {
	return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
}
/**
 * Return the font name of this ULCFont
 *
 * @return java.lang.String
 */
public String getFontName() {
	return fName;
}
/**
 * Get the font size of this ULCFont.
 *
 * @return int
 */
public int getFontSize() {
	return fSize;
}
/**
 * Get the font style of this ULCFont.
 * <pre>
 * style can be any combination of:
 * 	PLAIN, BOLD, ITALIC
 * </pre>
 * @return int
 */
public int getFontStyle() {
	return fStyle;
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fName != null)
		a.put("nm", fName);
	if (fSize != 10)
		a.put("s", fSize);
	if (fStyle != PLAIN)
		a.put("st", fStyle);
}
/**
 * Set the font name of this ULCFont
 *
 * @param java.lang.String
 */
public void setFontName(String fontName) {
	fName = fontName;
}
/**
 * Set the font size of this ULCFont
 *
 * @param int
 */
public void setFontSize(int fontSize) {
	fSize = fontSize;
}
/**
 * Set the font style of this ULCFont.
 * <pre>
 * style can be any combination of:
 * 	PLAIN, BOLD, ITALIC
 * </pre>
 * @param int
 */
public void setFontStyle(int fontStyle) {
	fStyle = fontStyle;
}
}
