package com.ibm.ulc.application;

/*
 * Copyright (c) 1999 Object Technology International Inc.
 */
import java.io.*;

/**
 * A file output stream is an output stream for writing data to a 
 * <code>ULCFile</code>. 
 *
 */
public class ULCFileOutputStream extends OutputStream {
	private BufferedOutputStream fDelegate = null;
	private ULCContext fContext = null;
/**
 * Creates a file output stream to write to the specified 
 * <code>ULCFile</code> object. 
 *
 * @param      file   the file to be opened for writing.
 * @exception  IOException        if the file could not be opened for
 *               writing.
 * @see        ULCFile#getPath()
 */
public ULCFileOutputStream(com.ibm.ulc.application.ULCContext context, ULCFile file) throws IOException {
	this(context, file.getPath());
}
/**
 * Creates an output file stream to write to the file with the 
 * specified name. 
 *
 * @param      context the ULCContext upon which the file stream should 
 *             be created.
 * @param      name   the system-dependent filename.
 * @exception  IOException  if the file could not be opened for writing.
 */
public ULCFileOutputStream(com.ibm.ulc.application.ULCContext context, String name) throws IOException {
	this(context, name, false);
}
/**
 * Creates an output file with the specified system dependent
 * file name.
 *
 * @param      context the ULCContext upon which the file stream should 
 *             be created.
 * @param name the system dependent file name 
 * @exception IOException If the file is not found.
 */
public ULCFileOutputStream(com.ibm.ulc.application.ULCContext context, String name, boolean append) throws IOException {
	fDelegate = new BufferedOutputStream(new AFileOutputStream(context, name, append), 64 * 1024);
	fContext = context;
}
/**
 * Closes this file output stream and releases any system resources 
 * associated with this stream. 
 *
 * @exception  IOException  if an I/O error occurs.
 */
public void close() throws IOException {
	fDelegate.close();
}
/**
 * Flushes this output stream and forces any buffered output bytes 
 * to be written out. 
 * <p>
 * The <code>flush</code> method of <code>OutputStream</code> does nothing.
 *
 * @exception  IOException  if an I/O error occurs.
 */
public void flush() throws IOException {
	fDelegate.flush();
}
/**
 * Writes <code>b.length</code> bytes from the specified byte array 
 * to this file output stream. 
 *
 * @param      b   the data.
 * @exception  IOException  if an I/O error occurs.
 */
public void write(byte b[]) throws IOException {
	fDelegate.write(b, 0, b.length);
}
/**
 * Writes <code>len</code> bytes from the specified byte array 
 * starting at offset <code>off</code> to this file output stream. 
 *
 * @param      b     the data.
 * @param      off   the start offset in the data.
 * @param      len   the number of bytes to write.
 * @exception  IOException  if an I/O error occurs.
 */
public void write(byte b[], int off, int len) throws IOException {
	fDelegate.write(b, off, len);
}
/**
 * Writes the specified byte to this file output stream. 
 *
 * @param      b   the byte to be written.
 * @exception  IOException  if an I/O error occurs.
 */
public void write(int b) throws IOException {
	fDelegate.write(b);
}
}
