package com.ibm.ulc.application;

import java.util.Vector;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.UlcRange;
/**
 * The ULCEmptyTableModel acts as model for tables which do not have an itemList
 * associated with them. It essentially acts as a 'Null Object' to avoid having to
 * check for nulls everywhere.
 */
class ULCEmptyTableModel extends ULCAbstractTableModel implements IIndexedTableModel, IHierarchicalTableModel {
	IRowAdapter fRowAdapter;
	IHierarchicalItemList fHierarchicalItemList;
	IIndexedItemList fIndexedItemList;
/**
 * Construct a new ULCEmptyTableModel
 */
public ULCEmptyTableModel() {
	super();
}
/**
 * By definition the receiver does not have any rows. Ignore this message.
 */
protected void addPreloadRows(Anything anything) {
}
/**
 * Answer the default itemList for the receiver
 */
ULCDefaultItemList getDefaultItemList() {
	return (ULCDefaultItemList) fIndexedItemList;
}
/**
 * Answer the default hierarchical itemlist of the receiver. This is used whenever
 * the receiver serves as model to a tree widget. There is no default value for this
 * property
 */
public IHierarchicalItemList getHierarchicalItemList() {
	return fHierarchicalItemList;
}
/**
 * Answer the indexed itemList on the receiver
 */
public IIndexedItemList getIndexedItemList() {
	return fIndexedItemList;
}
/**
 * Answer the row adapter for the receiver
 */
protected IRowAdapter getRowAdapter() {
	return fRowAdapter;
}
/**
 * Answer the object at the given index. Since the receiver is an empty
 * model, answer null
 *
 * @parm index		the index of the interface
 *
 */
public Object getRowAtIndex(int index) {
	return null;
}
/**
 * Answer the size of the receiver's row collection.
 */
public int getRowCount() {
	return 0;
}
/**
 * Initialize the receiver's itemList.
 *
 */
protected void initialize() {
	super.initialize();
	resetDefaultItemList(null);
	resetHierarchicalItemList(null);
	fRowAdapter = new ULCRowAdapter();
}
/**
 * reset the receiver's default itemList.
 *
 * @param	itemList	IIndexedItemList
 */
protected void resetDefaultItemList(IIndexedItemList itemList) {
	if (itemList == null || itemList == getIndexedItemList()) {
		fIndexedItemList = new ULCDefaultItemList();
		fIndexedItemList.setModel(this);
		addItemList(fIndexedItemList);
	}
}
/**
 * reset the receiver's default itemList.
 *
 * @param	itemList	IHierarchicalItemList
 */
protected void resetHierarchicalItemList(IHierarchicalItemList itemList) {
	if (itemList == null || itemList == getHierarchicalItemList()) {
		ULCTreeItemList newItemList = new ULCTreeItemList();
		newItemList.setModel(this);
		newItemList.setHierarchyAdapter(new ULCSimpleHierarchyAdapter());
		fHierarchicalItemList = newItemList;
		addItemList(newItemList);
	}
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveItemLists(Anything a) {
	a.put("iil", getIndexedItemList().getRef(fContext));
}
/**
 * Set the given row adapter as the receiver's row adapter.
 *
 * @param rowAdapter IRowAdapter 	the new row adapter for the receiver
 */
public void setRowAdapter(IRowAdapter rowAdapter) {
	fRowAdapter = rowAdapter;
}
/**
 * Set the receiver's RowCache to an indexed one. The receiver implements the IndexedTableModel
 * interface locally.
 */
protected void setRowCache() {
	setRowCache(new ULCIndexedRowCache(this, this));
}
}
