package com.ibm.ulc.application;

import com.ibm.ulc.base.*;
import com.ibm.ulc.util.*;
/**
 * The composite is used to build reusable sub-forms.
 */
public class ULCComposite extends ULCComponent {
	/**
	 * The component that will be sent up in my place.
	 * @serial
	 */
	protected ULCProxy fComponent = null;
/**
 * Create a ULCComposite that will act as a wrapper for a ULCWidget tree.
 */
public ULCComposite() {
	super();
}
/**
 * This widget is being destroyed perform any cleanUp necessary.
 */
public void free() {
	super.free();
	if (fComponent != null)
		fComponent.free();
	fComponent = null;
}
/**
 * ULCComposites are only wrappers for a ULCWidget so we forward this to the target component.
 */
public Anything getRef(ULCContext context) {
	if (context != null)
		fContext = context;
	if (fComponent != null)
		return fComponent.getRef(context);
	else
		return null;
}
/**
 * Returns true if this object was already uploaded to the UI.
 * We ask ULC whether our seed is recent.
 *
 * @return if false, the object needs to be uploaded.
 */
public boolean isUploaded() {
	if (fComponent == null)
		return false;
	else
		return fComponent.isUploaded();
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	if (fComponent != null)
		fComponent.saveState(a);
}
/**
 * The component that will be sent up in my place.
 */
public void setComponent(ULCProxy proxy) {
	fComponent = proxy;
}
}
