package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.ORBConnection;

/**
 * A menu item that can be selected or deselected.
 * If selected, the menu item typically appears with a checkmark next to it.
 * If unselected or deselected, the menu item appears without a checkmark.
 * Like a regular menu item, a checkbox menu item can have either text or a graphic icon associated with it, or both. 
 */
public class ULCCheckboxMenuItem extends ULCToggleMenuItem {
public ULCCheckboxMenuItem() {
	super("");
}
/**
 * 	Creates an initially unselected checkboxMenuItem with text
 *
 * @param text The string to be displayed
 */
public ULCCheckboxMenuItem(String text) {
	super(text);
}
/**
 * Creates an initially unselected checkboxMenuItem with label.
 * On state changes the given listener is notified.
 *
 * @param label The string to be displayed
 * @param l 	The widget interested in my state changes.
 */
public ULCCheckboxMenuItem(String label, IActionListener l) {
	super(label, l);
}
/**
 * Creates an initially unselected checkboxMenuItem with the specified text and icon.
 *
 * @param text The string to be displayed
 * @param icon 	The ULCIcon to be displayed alongside the text.
 */
public ULCCheckboxMenuItem(String text, ULCIcon icon) {
	super(text, icon);
}
/**
 * Creates an initially unselected checkboxMenuItem with the specified text and icon.
 * On state changes the given listener is notified.
 *
 * @param label The string to be displayed
 * @param icon 	The ULCIcon to be displayed alongside the label.
 * @param l 	The widget interested in my state changes.
 */
public ULCCheckboxMenuItem(String label, ULCIcon icon, IActionListener l) {
	super(label, icon, l);
}
}
