package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * An event that characterizes a semantic action,
 * for example the pressing of a button etc.
 *
 * @see IActionListener An interface for listening for this event.
 */
public class ULCActionEvent extends ULCEvent {
	/**
	 * The action command
	 * @serial
	 */
	protected String fCmd = null;
/**
 * Create an instance of an ULCActionEvent with source and command.
 *
 * @param source 	The source object refers to the object that generated this action.
 * @param command 	A command describes the event that occurred.
 */
public ULCActionEvent(Object source, String command) {
	super(source);
	fCmd = command;
}
/**
 * Dispatch this event to the listener if it implements the IActionListener interface.
 *
 * @param actionListener	The object that implements the  IActionListener interface.
 */
public void dispatch(IListener actionListener) {
	if (actionListener instanceof IActionListener) {
		IActionListener al = (IActionListener) actionListener;
		al.actionPerformed(this);
	}
}
/**
 * Returns the command name associated with this event.
 * If the command is null return the defaultString
 *
 * @param defaultString The value to be returned when the command is null.
 */
public String getCmd(String defaultString) {
	if (fCmd != null)
		return fCmd;
	return defaultString;
}
}
