package com.ibm.ulc.application;

import com.ibm.ulc.util.Anything;
import java.awt.event.InputEvent;
/**
 * Specifies a keyStroke to be used as a menuitem accelerator.
 */
public class ULCAccelerator implements java.io.Serializable {
	static final long serialVersionUID = 8963632591182884508L; 
	/**
	 * If >=0 Specifies the keyCode to be treated as an accelerator.
	 */
	protected int fKeyCode = -1;
	/**
	 * <pre>
	 * Sets the valid keyboard masks or modifier for this menuitem.
	 * valid modifiers are:
	 * InputEvent.SHIFT_MASK
	 * InputEvent.CTRL_MASK
	 * InputEvent.META_MASK
	 * InputEvent.ALT_MASK
	 * </pre>
	 */
	protected int fModifiers=InputEvent.ALT_MASK;;
	/**
	 * If true the accelerator is triggerred on key release.
	 */
	protected boolean fOnKeyRelease= true;
/**
 * ULCAccelerator is used to specify keystroke combinations that are used as menu
 * item accelerators.
 */
public ULCAccelerator() {
	super();
}
public Anything asStcAnything() {
	Anything accel = new Anything();
	accel.put("keyCode", fKeyCode);
	accel.put("modifier", fModifiers);
	accel.put("onKeyRelease", fOnKeyRelease);
	return accel;
}
/**
 * Returns true if this object is identical to the specified object.
 *
 * @param anObject the Object to compare this object to
 * @return true if the objects are identical
 */
public boolean equals(Object anObject) {
	if (this == anObject)
		return true;
	if (anObject instanceof ULCAccelerator) {
		ULCAccelerator accel = (ULCAccelerator) anObject;
		if (accel.getKeyCode() == getKeyCode() && accel.isOnKeyRelease() == isOnKeyRelease() && accel.getModifiers() == getModifiers())
			return true;
	}
	return false;
}
/**
 * Return an instance of a key stroke given a char code and a set
 * of modifiers, specifying whether the key is activated when it is pressed
 * or released.
 * <p>
 * The "virtual key" constants defined in java.awt.event.KeyEvent can be 
 * used to specify the key code. For example:<ul>
 * <li>java.awt.event.KeyEvent.VK_ENTER 
 * <li>java.awt.event.KeyEvent.VK_TAB
 * <li>java.awt.event.KeyEvent.VK_SPACE
 * </ul>
 * The modifiers consist of any combination of:<ul>
 * <li>java.awt.Event.SHIFT_MASK (1)
 * <li>java.awt.Event.CTRL_MASK (2)
 * <li>java.awt.Event.META_MASK (4)
 * <li>java.awt.Event.ALT_MASK (8)
 * </ul>
 * Since these numbers are all different powers of two, any combination of
 * them is an integer in which each bit represents a different
 * modifier key.
 *
 * @param keyCode an int specifying the numeric code for a keyboard key
 * @param modifiers an int specifying any combination of the key modifiers.
 * @param onKeyRelease a boolean value. When true, specifies that
 *        the key is active when it is released.
 * @return a KeyStroke object for that key
 *
 * @see java.awt.event.KeyEvent
 * @see java.awt.Event
 */
public static ULCAccelerator getAccelerator(int keyCode, int modifiers, boolean onKeyRelease) {
	ULCAccelerator accel = new ULCAccelerator();
	accel.setKeyCode(keyCode);
	accel.setModifiers(modifiers);
	accel.setOnKeyRelease(onKeyRelease);
	return accel;
}
/**
 * Gets the character value of the key used as the accelerator.
 *
 * @return keyCode 		The <code>int</code> character value of the key to be used as the accelerator.
 */
public int getKeyCode() {
	return fKeyCode;
}
/**
 * Gets the modifier for this accelerator.
 * <pre>
 * valid modifiers are:
 * InputEvent.SHIFT_MASK
 * InputEvent.CTRL_MASK
 * InputEvent.META_MASK
 * InputEvent.ALT_MASK
 * </pre>
 *
 */
public int getModifiers() {
	return fModifiers;
}
/**
 * @return onKeyRelease 	If true, the accelerator is triggered on key release.
 */
public boolean isOnKeyRelease() {
	return fOnKeyRelease;
}
/**
 * Sets the character value of the key to be used as the accelerator.
 *
 * @param keyCode 		The <code>int</code> character value of the key to be used as the accelerator.
 */
public void setKeyCode(int keyCode) {
	fKeyCode = keyCode;
}
/**
 * Sets the modifier for this accelerator.
 * <pre>
 * valid modifiers are:
 * InputEvent.SHIFT_MASK
 * InputEvent.CTRL_MASK
 * InputEvent.META_MASK
 * InputEvent.ALT_MASK
 * </pre>
 *
 */
public void setModifiers(int modifiers) {
	fModifiers = modifiers;
}
/**
 * @param onKeyRelease 	If true, the accelerator is triggered on key release.
 */
public void setOnKeyRelease(boolean onKeyRelease) {
	fOnKeyRelease = onKeyRelease;
}
}
