package com.ibm.ulc.application;

import com.ibm.ulc.application.*;
import com.ibm.ulc.comm.*;
import com.ibm.ulc.util.*;
import java.util.*;
/**
 * This RowCache is index based. It uses an instance of <code>ULCIndexedItemList</code>
 * to manage the mapping between indices and rowIds. This class is used by TableModels unless
 * another is specified by the developer.
 */
abstract public class ULCAbstractRowCache extends UlcObject implements IRowCache {
	private ULCAbstractTableModel fModel;
	private int fNextOid = 0;
/**
 * Create an instance of the receiver with the specified itemList. The itemList passed is used to manage the
 * index to rowId mappings for the receiver.
 *
 * Creation date: (10/25/99 6:25:31 PM)
 * @param itemList com.ibm.ulc.application.ULCIndexedItemList
 */
public ULCAbstractRowCache(ULCAbstractTableModel model) {
	fModel = model;
}
/**
 * Calling this API will force all rows of the receiver's tableModel to be identified by a unique oid.
 * This implementation does not touch the database. When itemlists of the receiver's model need the
 * oid for a given row, they must get it using the receiver's #getRowIdFor API.
 *
 * @see #getRowIdFor
 */
public int[] getAllRowIds() {
	int[] answer = new int[getRowCount()];
	for (int i = 0; i < answer.length; i++) {
		answer[i] = getNextOid();
		getCachedRow(answer[i]);
	}
	return answer;
}
/**
 * Answer the cached row at the specified rowId.
 */
abstract UlcCachedRow getCachedRow(int rowId);
/**
 * Answer the oid that marks invalid and/or non-existing rows. Default is -1.
 */
protected int getInvalidOid() {
	return -1;
}
/**
 * Answer the general tableModel interface of the receiver's model
 */
protected ULCAbstractTableModel getModel() {
	return fModel;
}
/**
 * Answer the next oid available for the receiver.
 */
int getNextOid() {
	return fNextOid++;
}
/**
 * Answer the application object defined by <code>rowId</code>. Answer null, if the object was not found.
 *
 * @param rowId	The identfier of the row being accessed.
 */
abstract public java.lang.Object getRowAtRowId(int rowId);
/**
 * Answer the total number of rows in the receiver
 */
public int getRowCount() {
	return getModel().getRowCount();
}
/**
 * Answer the rowId for userObject. If it is not already defined, a new one will be assigned
 * and answered.
 */
abstract public int getRowIdFor(Object userObject);
/**
 * The specified rowId was uplaoded to the UI.
 */
public boolean isUploaded(int oid) {
	return getCachedRow(oid).isUploaded();
}
protected UlcCachedRow newCachedRow(Object object) {
	return new UlcCachedRow(object);
}
/**
 * The specified oid was assigned for object. Add the mapping to the receiver.
 */
public void setRowIdFor(int oid, Object object) {
	UlcCachedRow cachedRow = getCachedRow(oid);
	cachedRow.setObject(object);
}
/**
 * The specified rowId was uplaoded to the UI.
 */
public void setUploaded(int oid) {
	getCachedRow(oid).setUploaded();
}
}
