package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * This interface is used in order to listen for events on 
 * the tree (ULCTree and ULCTreeModel).
 *
 * @see ULCTree#addTreeExpandActionListener(ITreeListener)
 * @see ULCTreeEvent
 */
public interface ITreeListener extends IListener {
/**
 * The user has double clicked a node in the tree, do any processing necessary.
 * 
 * @param e ULCTreeEvent 
 */

void treeActionPerformed(ULCTreeEvent e);
/**
 * The user has collapsed a node in the tree, do any processing necessary.
 * 
 * @param e ULCTreeEvent  
 */
void treeCollapsed(ULCTreeEvent e);
/**
 * The user has expanded a node in the tree, do any processing necessary.
 *
 * @param e ULCTreeEvent  
 */

void treeExpanded(ULCTreeEvent e);
/**
 * The user has selected a node in the tree, do any processing necessary.
 *
 * @param e ULCTreeEvent  
 */

void treeSelected(ULCTreeEvent e);
}
