package com.ibm.ulc.application;

/**
 * Insert the type's description here.
 * Creation date: (10/25/99 5:31:41 PM)
 * @author: Stefan Bosshard, OTI
 */
public interface IRowCache  {
/**
 * Answer an array holding all current oids of the receiver
 */
public int[] getAllRowIds();
/**
 * Answer the application object defined by <code>rowId</code>. Answer null, if the object was not found.
 *
 * @param rowId	The identfier of the row being accessed.
 */
public Object getRowAtRowId(int rowId);
/**
 * Answer the total number of rows available from the receiver. This includes all rows not cached already. 
 *
 */
public int getRowCount();
/**
 * Answer the row id for the specified user object. If the object is found but 
 * is not associated with a rowid, a new oid is assigned and answered.
 * If the object cannot be found in the receiver's data answer -1.
 */
public int getRowIdFor(Object object);
/**
 * Answer true if the object associated with the specified oid is uploaded to the UI.
 */
public boolean isUploaded(int oid);
/**
 * The object identified by the specified oid was removed. remove all mappings in the receiver.
 */
public void resetRowId(int oid);
/**
 * The specified oid was assigned for object. Add the mapping to the receiver.
 */
public void setRowIdFor(int oid, Object object);
/**
 * The specified rowId was uplaoded to the UI.
 */
public void setUploaded(int oid);
}
