package com.ibm.ulc.application;

import java.util.Vector;
/**
 * This interface tags the hierarchical adapters used for adapting ULC hierarchical
 * elements (e.g. nodesin a tree) onto the business objects providing the required
 * data.
 */
public interface IHierarchyAdapter {
/**
 * Answer the number of children for the given node.
 *
 * @param node The domain object whose childCount is required.
 */
public int getChildCount(Object node);
/**
 * Answer the child nodes of node.
 *
 * @param node The domain object whose children are required.
 */
public Vector getChildren(Object node);
/**
 * Answer the default root of the hierarchy. This is needed because current implementation 
 * of Swing demands a valid node as root object for every tree widget. The root of a given view
 * can be set using the IHierarchicalItemList.setRoot API.
 *
 */
public Object getDefaultRoot();
/**
 * Answer the parent of node. Answer null if that node is the root.
 *
 * @param node The domain object whose parent is required.
 */
public Object getParent(Object node);
/**
 * Answer true if the specified attributeName is the attribute
 * defining the children of a node.
 * 
 *
 */
public boolean isChildrenAttribute(String attributeName);
/**
 * Answer true if the specified attributeName is the attribute
 * defining the parentage of a node.
 * 
 *
 */
public boolean isParentAttribute(String attributeName);
}
