package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/**
 * This interface is used in order to listen if
 * the current value (examples ULCField, ULCSlider) has changed.
 * The <code>hasChanged(ULCHasChangedEvent)</code> must be implemented to
 * react on the change.
 *
 * @see		ULCAbstractModel#addHasChangedListener
 * @since	R3.1
 *		
 */
public interface IHasChangedListener extends IChangedListener {
/**
 * A value has changed in the widget, do any processing necessary.
 *
 * @since	R3.1
 */

void hasChanged(ULCHasChangedEvent e);
}
