package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.application.ULCIcon;
import java.util.Vector;

/**
 * IGenericTreeNode tags objects which can be used as an element inside the GenericTreeModel.
 *
 * @see com.ibm.ulc.application.ULCTreeModel
 * @see com.ibm.ulc.application.GenericTreeModel
 */
public interface IGenericTreeNode {
/**
 * Add the given node to the receiver.
 *
 * @param node	IGenericTreeNode	The node to be added.
 */
void addNode(IGenericTreeNode node);
/**
 * Add the given node to the receiver. Notify the UI of
 * this fact based on the notify flag.
 *
 * @param node		IGenericTreeNode	The node to be added.
 * @param notify	boolean				Whether to notify the UI after the
 *										addition, or not.
 */
void addNode(IGenericTreeNode node, boolean notify);
/**
 * Add the given nodes to the receiver. 
 *
 * @param nodes		Vector		The nodes to be added.
 */
void addNodes(Vector nodes);
/**
 * Answer the number of children in the receiver
 */
int getChildCount();
/**
 * Answer the receiver's children
 */
public Vector getChildren();
/**
 * Answer the icon corresponding to the receiver.
 * Note : This method will get called only if you are using the receiver
 * inside a ULCTree. However, it is recommended that R3.0 onwards, you use
 * the ULCTreeTable widget instead.
 *
 * @see ULCTree
 * @see ULCTreeTable
 */
public ULCIcon getIcon();
/**
 * Answer the label corresponding to the receiver.
 * Note : This method will get called only if you are using the receiver
 * inside a ULCTree. However, it is recommended that R3.0 onwards, you use
 * the ULCTreeTable widget instead.
 *
 * @see ULCTree
 * @see ULCTreeTable
 */
public String getLabel();
/**
 * Answer the parent node for the receiver.
 */
public IGenericTreeNode getParent();
/**
 * Remove the given node to the receiver.
 *
 * @param node	IGenericTreeNode	The node to be removed.
 *
 * @result boolean	Answer whether the removal was successful or not.
 */
boolean removeNode(IGenericTreeNode node);
/**
 * Remove the given node to the receiver. Notify the UI of
 * this fact based on the notify flag.
 *
 * @param node		IGenericTreeNode	The node to be removed.
 * @param notify	boolean				Whether to notify the UI after the
 *										removal, or not.
 * @result boolean	Answer whether the removal was successful or not.
 */
boolean removeNode(IGenericTreeNode node, boolean notify);
/**
 * Set the parent node for the receiver, to the given
 * node.
 *
 * @param node	IGenericTreeNode	The node to be set as my parent
 */
public void setParent(IGenericTreeNode parent);
}
