package com.ibm.ulc.application;

/**
 * Items of ULCContainer have to
 * implement this interface.
 */
public interface IContainerItem {
/**
 * Get the icon of the item
 *
 * @return The item's icon as <code>ULCIcon</code>
 */
ULCIcon getIcon();
/**
 * Get a text representation
 * of the item
 *
 * @return The item's <code>String</code> value
 */
String getLabel();
/**
 * Get the popup menu of the item
 *
 * @return 	The item's popup menu as <code>ULCMenu</code>
 */
public ULCMenu getPopupMenu();
/**
 * Get the tool tip text
 *
 * @return The text to be displayed when the mouse lingers over this object.
 */
public String getToolTipText();
}
