package com.ibm.ulc.application;

/*
 * Copyright (c) 1997-1999 Object Technology International Inc.
 */

import java.util.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.ORBConnection;
/**
 * Implementation of a default ULCTreeModel that can be used for simple applications.
 */
public class GenericTreeModel extends ULCTreeModel {
	/**
	 * @serial
	 */
	private Object fRoot = null;
/**
 * GenericTreeModel constructor comment.
 */
public GenericTreeModel() {
	super();
	fRoot = new GenericTreeNode(this);
}
/**
 * GenericTreeModel constructor comment.
 * @param prefetchCount int
 */
public GenericTreeModel(int prefetchCount) {
	super(prefetchCount);
	fRoot=new GenericTreeNode(this);
}
/**
 * Convenience method to add a new child to an existing parent.
 *
 * @param parent		The parent to whom the new child is to be added
 * @param newChild		The child to be added to this parent.
 *						The child is added at the end of the parent's
 *						existing list of children.
 *
 */
public void addChild(IGenericTreeNode parent, IGenericTreeNode newChild) {
	parent.addNode(newChild);
}
/**
 * Convenience method to add a new child to an existing parent.
 *
 * @param parent		The parent to whom the new child is to be added
 * @param newChild		The child to be added to this parent.
 *						The child is added at the end of the parent's
 *						existing list of children.
 *
 */
public void addChildren(IGenericTreeNode parent, Vector newChildren) {
	parent.addNodes(newChildren);
}
/**
 * Add a IGenericTreeNode to myself and notify the UI.
 *
 */
public void addNode(IGenericTreeNode treeNode) {
	((GenericTreeNode) getRoot()).addNode(treeNode);
}
/**
 * Adds the specified ITreeNode collection and notify the UI.
 */
public void addNodes(Vector vectorOfTreeNodes) {
	((GenericTreeNode) getRoot()).addNodes(vectorOfTreeNodes);
}
/**
 * Create a new GenericTreeNode
 */
public GenericTreeNode createNewTreeNode(ULCIcon icon, String label) {
	GenericTreeNode node = new GenericTreeNode(this);
	node.setLabel(label);
	node.setIcon(icon);
	return node;
}
/**
 * getChildCount method comment.
 */
public int getChildCount(Object node) {
	return ((IGenericTreeNode) node).getChildCount();
}
/**
 * getChildren method comment.
 */
public java.util.Vector getChildren(Object treeNode) {
	return ((IGenericTreeNode) treeNode).getChildren();
}
/**
 * Satisfy the IHierarchyAdapter protocol. Answer the receiver's root object.
 */
public Object getDefaultRoot() {
	return getRoot();
}
/**
 * getIcon method comment.
 */
public ULCIcon getIcon(Object treeNode) {
	return ((IGenericTreeNode) treeNode).getIcon();
}
/**
 * getLabel method comment.
 */
public String getLabel(Object treeNode) {
	return ((IGenericTreeNode) treeNode).getLabel();
}
/**
 * Override this method to return the parent object
 * for the given userObject (child). This method is (only)
 * required in case operations (e.g. setSelection) are being
 * performed on a node which has not yet been uploaded to the
 * UI side.
 * By default, the Root will be assumed to be the parent. (!)
 *
 * @param child	The domain object whose parent is required.
 */
public Object getParent(Object child) {
	return ((GenericTreeNode) child).getParent();
}
/**
 * getRoot method comment.
 */
public Object getRoot() {
	return fRoot;
}
/**
 * Override this method to return the requested value for the 
 * specified cell.
 * This method needs to be overridden by subclasses if they
 * have added columns to the receiver's tree.
 *
 * @param attributeName	The key of the attribute to be retrieved.
 * @return Object 
 */
public Object getValueAt(String attributeName, Object treeNode) {
	if (treeNode instanceof ITableRow)
		return ((ITableRow) treeNode).getValueAt(attributeName);
	else
		return null;
}
/**
 * Add a IGenericTreeNode to myself and notify the UI.
 *
 */
public void removeNode(IGenericTreeNode treeNode) {
	((GenericTreeNode) getRoot()).removeNode(treeNode);
}
/**
 * Remove the specified ITreeNode collection and notify the UI.
 */
public void removeNodes(Vector vectorOfTreeNodes) {
	((GenericTreeNode) getRoot()).removeNodes(vectorOfTreeNodes);
}
/**
 * Set the given object as the new root for the receiver
 *
 * @param 	treeNode 	Object	The new root for the receiver's hierarchy
 */
public void setRoot(Object treeNode) {
	fRoot = treeNode;
}
}
