package com.ibm.ulc.application;

/**
 * GenericTableRowAdapter implements a generic wrapper class that can be used to
 * adapt your user defined model classes to be used within any ULC widget that requires 
 * an ITableRow implementation. The user defined model class must implement public
 * getter and setter methods following java beans conventions for all properties
 * that will be accessed using this adapter.
 *
 * Note: Since this class uses reflection performance can be an issue for large collections.
 */
import java.util.Vector;
import java.lang.reflect.*;
import com.ibm.ulc.util.*;
public class GenericTableRowAdapter extends ULCRowAdapter implements ITableRow {
	/**
	 * The reference to the user  model that is being adapted.
	 */
	private Object fModel = null;
/**
 * GenericTableRowAdapter implements a generic wrapper class that can be used to
 * adapt your business model classes to be used within any ULC widget that requires 
 * an ITableRow implementation. The business model class must implement public
 * getter and setter methods following java beans conventions for all properties
 * that will be accessed using this adapter.
 */
public GenericTableRowAdapter() {
	super();
}
/**
 * GenericTableRowAdapter implements a generic wrapper class that can be used to
 * adapt your business model classes to be used within any ULC widget that requires 
 * an ITableRow implementation. The business model class must implement public
 * getter and setter methods following java beans conventions for all properties
 * that will be accessed using this adapter.
 *
 * @param model The user defined model class that is being adapted for an ITableRow
 */
public GenericTableRowAdapter(Object model) {
	fModel = model;
}
public boolean equals(Object object) {
	return (object instanceof GenericTableRowAdapter && fModel.equals(((GenericTableRowAdapter) object).getModel()));
}
/**
 * Return the getter method that matches the attributeName.
 */
private Method getAccessMethod(String attributeName) {
	return getAccessMethod(fModel, attributeName);
}
/**
 * Return the user defined model class that is being adapted for use as a ITableRow
 */
public Object getModel() {
	return fModel;
}
/**
 * Return the setter method that matches the attributeName
 */
private Method getSetterMethod(String attributeName, Object value) {
	return getSetterMethod(fModel, attributeName, value);
}
/**
 * Answer the value for the given object at the given attribute.
 *
 * @param attributeName 	String		The attribute at which the value is requested
 * @param object			Object		The object whose value at the above attribute
 *										is asked for.
 */
public Object getValueAt(String attributeName) {
	return getValue(attributeName, fModel);
}
/**
 * Set the user defined model class that is being adapted for use as a ITableRow
 */
public void setModel(Object model) {
	fModel = model;
}
/**
 * Convenience method to wrap a byte value as an object
 * and assign it to my model at the specified attributeName.
 */
public void setValueAt(byte value, String attributeName) {
	setValueAt(new Byte(value), attributeName);
}
/**
 * Convenience method to wrap a char value as an object
 * and assign it to my model at the specified attributeName.
 */
public void setValueAt(char value, String attributeName) {
	setValueAt(new Character(value), attributeName);
}
/**
 * Convenience method to wrap a double value as an object
 * and assign it to my model at the specified attributeName.
 */
public void setValueAt(double value, String attributeName) {
	setValueAt(new Double(value), attributeName);
}
/**
 * Convenience method to wrap an int value as an object
 * and assign it to my model at the specified attributeName.
 */
public void setValueAt(int value, String attributeName) {
	setValueAt(new Integer(value), attributeName);
}
/**
 * Convenience method to wrap a long value as an object
 * and assign it to my model at the specified attributeName.
 */
public void setValueAt(long value, String attributeName) {
	setValueAt(new Long(value), attributeName);
}
/**
 * Set the attributeName value of the object to the specified value.
 * Since this is an object of no specified type, we use java reflection
 * to set this value.
 *
 * @param attributeName 	String	The attribute
 * @param value				Object	The value to which the above attribute
 *									is being set.
 * @param object			ITableRow	The object whose value at the above attribute
 *									is being set.
 */
public void setValueAt(Object value, String attributeName) {
	setValue(attributeName, value, fModel);
}
/**
 * Convenience method to wrap a short value as an object
 * and assign it to my model at the specified attributeName.
 */
public void setValueAt(short value, String attributeName) {
	setValueAt(new Short(value), attributeName);
}
/**
 * Convenience method to wrap a boolean value as an object
 * and assign it to my model at the specified attributeName.
 */
public void setValueAt(boolean value, String attributeName) {
	setValueAt(new Boolean(value), attributeName);
}
}
