package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.util.Anything;
import java.util.Vector;
import java.util.Enumeration;

/**
 * Internal class representing the ULC supported attributes of a box cell.
 */
class BoxCellAttributes extends ULCProxy {
	private ULCComponent fComp= null;
	private String fAttr= null;
	private int fHSpan= 1;
	private int fVSpan= 1;
	private int fGridX= -1;
	private int fGridY= -1;
BoxCellAttributes(ULCComponent c, int x, int y) {
	fComp = c;
	fGridX = x;
	fGridY = y;
}
BoxCellAttributes(ULCComponent c, int x, int y, int hspan) {
	fComp = c;
	fGridX = x;
	fGridY = y;
	fHSpan = hspan;
}
BoxCellAttributes(ULCComponent c, int x, int y, int hspan, int vspan) {
	fComp = c;
	fGridX = x;
	fGridY = y;
	fHSpan = hspan;
	fVSpan = vspan;
}
BoxCellAttributes(ULCComponent c, int x, int y, int hspan, int vspan, String attr) {
	fComp = c;
	fGridX = x;
	fGridY = y;
	fHSpan = hspan;
	fVSpan = vspan;
	fAttr = attr;
}
BoxCellAttributes(ULCComponent c, int x, int y, String attr) {
	fComp = c;
	fGridX = x;
	fGridY = y;
	fAttr = attr;
}
BoxCellAttributes(ULCComponent c, int x, int y, String attr, int hspan) {
	fComp = c;
	fGridX = x;
	fGridY = y;
	fAttr = attr;
	fHSpan = hspan;
}
/**
 * This widget is being destroyed perform any cleanUp necessary.
 */
public void free() {
	super.free();
	if (fComp != null)
		fComp.free();
	fComp = null;
}
public ULCComponent getComponent() {
	return fComp;
}
public Anything getRef(ULCContext context) {
	Anything a = new Anything();
	if (fComp != null)
		a.put("c", fComp.getRef(context));
	if (fGridX != -1)
		a.put("x", new Anything(fGridX));
	if (fGridY != -1)
		a.put("y", new Anything(fGridY));
	if (fHSpan != 1)
		a.put("hs", new Anything(fHSpan));
	if (fVSpan != 1)
		a.put("vs", new Anything(fVSpan));
	if (fAttr != null && !fAttr.equals("lc"))
		a.put("a", fAttr);
	return a;
}
}
