package com.ibm.ulc.application;

import java.io.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.util.*;

class AFileInputStream extends InputStream {
	private ULCGenericProxy fFileInputStreamProxy = null;
public AFileInputStream(ULCContext context, String name) throws FileNotFoundException {
	fFileInputStreamProxy = new ULCGenericProxy(context, "com.ibm.ulc.ui.io.UIFileInputStream");
	Anything reply = fFileInputStreamProxy.syncCall("construct", new Anything(name));
	if (reply.isDefined("exception"))
		throw ((FileNotFoundException) reply.get("exception").asSerializable(null));
}
public void close() throws IOException {
	Anything reply = fFileInputStreamProxy.syncCall("close", null);
	super.close();
	if (reply.isDefined("exception"))
		throw ((FileNotFoundException) reply.get("exception").asSerializable(null));
}
protected void finalize() {
	fFileInputStreamProxy.unregister();
}
public int read() throws IOException {
	Anything reply = fFileInputStreamProxy.syncCall("read", null);
	if (reply.isDefined("exception"))
		throw ((IOException) reply.get("exception").asSerializable(null));
	return (byte) reply.asInt(0);
}
public int read(byte b[]) throws IOException {
	return read(b, 0, b.length);
}
public int read(byte b[], int off, int len) throws IOException {
	Anything reply = fFileInputStreamProxy.syncCall("readBytes", new Anything(len));
	if (reply.isDefined("exception")) {
		throw ((IOException) reply.get("exception").asSerializable(null));
	}
	if (reply.getType() == Anything.BYTES) {
		byte a[] = reply.asBytes();
		System.arraycopy(a, 0, b, off, a.length);
		return a.length;
	}
	return -1;
}
public long skip(long n) throws IOException {
	Anything reply = fFileInputStreamProxy.syncCall("skip", new Anything(n));
	if (reply.isDefined("exception")) {
		throw ((IOException) reply.get("exception").asSerializable(null));
	}
	return reply.asLong(0);
}
}
