package com.ibm.ulc.UIApplet;

import javax.swing.JApplet;
import java.awt.*;
import java.awt.event.*;
import java.util.Properties;
import com.ibm.ulc.base.IDefaults;
import com.ibm.ulc.ui.*;
import com.ibm.ulc.comm.IRequestProcessor;
import com.ibm.ulc.ui.base.SwingRequestProcessor;
import com.ibm.ulc.ui.base.AWTRequestProcessor;
import com.ibm.ulc.comm.ThreadPool;
import com.ibm.ulc.comm.UlcTransport;

/**
 * Wrapper applet that allows the ULC UI Engine to be started 
 * as an applet in a web browser.
 */
public class UIApplet extends JApplet implements IDefaults {
	String fTitle = "UIEngineApplet";
	String fURL = "no URL";
	boolean fDebug = false;
	boolean fInPlace = false;
	private UI fUI = null;
	protected UIShell fShell = null;
public UIApplet() {
	getRootPane().putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
}
/**
  * Cleans up whatever resources are being held. If the applet is active
  * it is stopped.
  * 
  * @see #init
  * @see #start
  * @see #stop
  */
public void destroy() {
	synchronized (UIApplet.class) {
		if (fDebug)
			System.out.println("<UIApplet.destroy()");
		fShell= null;
		if (fUI != null) {
			if (fDebug)
				System.out.println("UIApplet: Calling UI.cleanup()...");
			fUI.cleanup();
			if (fUI.getApplet() != null) {
				if (fDebug)
					System.out.println("UIApplet.destroy(): start waiting...");
				synchronized (this) {
					try {
						this.wait();}
					catch (InterruptedException e) {
						if (fDebug)
							e.printStackTrace();
					}
				}
			}
		}
		fUI= null;		
		// give parent a chance to clean up
		super.destroy();
		if (fDebug)
			System.out.println(">UIApplet.destroy()");
	}
}		
	/**
 	 * Information about this applet.
 	 */
	public String getAppletInfo() {
		return "UIApplet\n" + 
		"\n" + 
		"Author: OTI\n" + 
		"Applet/Application to run the UI Engine.\n" + 
		"";
	}
	/**
 	 * Parameter info for this applet
 	 */
	public java.lang.String[][] getParameterInfo() {
		String[][] info= {
			{"title", "String", "Title to appear in the applet area"},
			{"inplace",	"boolean", "Run UIEngine in place (in browser window)"},
			{"debug",	"boolean", "Print debug output"},
			{"url", "String", "URL to connect to"},
			{"indirectUrl", "String", "URL containing URL to connect to"},
			{"locale", "String", "ISOlanguage_ISOCountry"},
			{"look", "String", "Look&Feel_class"},
			{"monitor",	"boolean", "Run ORB monitor as well"},
			{"ipaddr",	"boolean", "Use IP addresses instead of names"},
			{"userParameter", "String", "Optional User parameter"},
			{"doublebuffering",	"boolean", "Toggles double buffering"},
			{"useAwtProcessor",	"boolean", "Use AwtRequestProcessor (Debugging only)"},
			{"org.omg.CORBA.ORBClass",	"String", "Class name of ORB implementation"},
			{"org.omg.CORBA.ORBSingletonClass",	"String", "Class name of singleton ORB implementation"},
			{"clientReconnect",	"boolean", "Retry to connect to the server for each connection which went down"}
		};
		return info;
	}
public UIShell getUIShell() {
	return fShell;
}
/**
 * Initializes the applet.
 */
public void init() {
	String value= getParameter("debug");
	if (value != null && value.equals("true")) {
		fDebug= true;
		System.out.println("<UIApplet.init()");
	}
	String vers= System.getProperty("java.version");
	synchronized (UIApplet.class) {
		if (fDebug)
			System.out.println("UIApplet.init: entering synchronized block");
		if (vers.compareTo(MIN_JVM_VERSION) < 0) {
			System.out.println("ERROR: UI Engine must be run with a " + MIN_JVM_VERSION + " or higher VM version!");
			stop();
			destroy();
			return;
		}
		super.init();
		String[] args= new String[30];
		boolean useAwtProcessor = false;
		int argc = 0;
		args[argc++]= "-applet";
		if (fDebug)
			args[argc++]= "-debug";
		value= getParameter("title");
		if (value != null) {
			fTitle= value;
			if (fDebug)
				System.out.println("    title=" + value);
		}
		value= getParameter("inplace");
		if (value != null && value.equals("true")) {
			fInPlace = true;
			if (fDebug)
				System.out.println("    inplace=" + value);
		} else
			resize(100, 100);
		value= getParameter("url");
		if (value != null) {
			args[argc++]= "-url";
			args[argc++]= value;
			fURL = value;
			if (fDebug)
				System.out.println("    url=" + value);
		}
		value= getParameter("indirectUrl");
		if (value != null) {
			args[argc++]= "-indirectUrl";
			args[argc++]= value;
			fURL= value;
			if (fDebug)
				System.out.println("    indirectUrl=" + value);
		}
		value= getParameter("locale");
		if (value != null) {
			args[argc++]= "-locale";
			args[argc++]= value;
			if (fDebug)
				System.out.println("    locale=" + value);
		}
		value= getParameter("userParameter");
		if (value != null) {
			args[argc++]= "-userParameter";
			args[argc++]= value;
			if (fDebug)
				System.out.println("    userParameter=" + value);
		}
		value= getParameter("look");
		if (value != null) {
			args[argc++]= "-look";
			args[argc++]= value;
			if (fDebug)
				System.out.println("    look=" + value);
		}
		value= getParameter("monitor");
		if (value != null && value.equals("true")) {
			args[argc++]= "-m";
			System.out.println("    monitor=true");
		}
		value= getParameter("ipaddr");
		if (value != null && value.equals("true")) {
			args[argc++]= "-ipaddr";
			System.out.println("    ipaddr=true");
		}
		value= getParameter("doublebuffering");
		if (value != null && value.equals("false")) {
			args[argc++]= "-doublebuffering";
			System.out.println("    doublebuffering=false");
		}
		value= getParameter("useAwtProcessor");
		if (value != null && value.equals("true")) {
			args[argc++]= "-useAwtProcessor";
			useAwtProcessor= true;
			System.out.println("    useAwtProcessor=true");
		}
		value= getParameter("autoReconnect");
		if (value != null) {
			args[argc++]= "-autoReconnect";
			useAwtProcessor= true;
			System.out.println("    autoReconnect=true");
		}

		// optional CORBA parameters (pass to transport layer)
		Properties props= UlcTransport.getProperties();
		if (props != null)
			props.put("Applet", this);

		// create new UI Engine
		String[] realArgs = new String[argc];
		for (int i= 0; i < argc; i++)
			realArgs[i]= args[i];
		if (useAwtProcessor)
			fUI= new UI(realArgs, new AWTRequestProcessor(), this);
		else
			fUI= new UI(realArgs, new SwingRequestProcessor(), this);
		fUI.establishConnection();
		if (fDebug)
			System.out.println(">UIApplet.init()");
	}
}
public boolean isInPlace() {
	return fInPlace;
}
/**
 * paint() draws the text on the drawing area.
 */
public void paint(Graphics g) {
	if (fInPlace)
		super.paint(g);
	else {
		g.drawString(fTitle, 30, 30);
		g.drawString("(" + fURL + ")", 30, 50);
	}
}
private void printThreads() {
	// print out entire threadgroup
	ThreadGroup group = Thread.currentThread().getThreadGroup();
	System.out.println("Thread Group: " + group.toString());
	group.list();
}
public void setUIShell(UIShell shell) {
	fShell = shell;
}
/**
 * start() fires up the thread.
 */
public void start() {
	if (fDebug)
		System.out.println("UIApplet start() called.");
}
/**
 * stop() terminates the thread and leaves it for garbage collection.
 */
public void stop() {
	if (fDebug)
		System.out.println("UIApplet stop() called.");
}
}
