package com.ibm.ulc.HttpServer;


/*
 * Copyright (c) 1998 Object Technology International Inc.
 */


import java.net.*;
import java.io.*;
import java.util.Properties;
import java.awt.Point;
import com.ibm.ulc.util.UlcConsole;
import com.ibm.ulc.comm.*;


public class HttpServer extends Server {

	static final String FILESEP =
		System.getProperty("file.separator");

	static public boolean fgDebug = false;
	static public Properties fgProperties = new Properties();
	static public String fgDocumentRoot = null;
	static private boolean fgCaseWarning= false;
	static private boolean fgEmulateUnix= false;
	static private boolean fgNoResources= false;
	
	public boolean fDebug = false;

	public HttpServer(String args[]) {
		super("ULC HttpServer");
		for (int i = 0; i < args.length; i++) {
			if (args[i].startsWith("-")) {
				if (args[i].equals("-debug") ) {
					fDebug = true;
					continue;
				}
			}
		}
	}
public void createConnection(UlcTransport transport) {
	if (transport instanceof UlcSocketTransport) {
		Socket socket= ((UlcSocketTransport) transport).getSocket();
		if (socket != null)
			new HttpConnection(socket,this);
	}
}
	protected void createConnection(Socket socket) {
		new HttpConnection(socket,this);
	}
/**
 * @return java.io.InputStream
 * @param resource java.lang.String
 */
public static InputStream getDocumentRootResourceStream(String resource) {
	if (fgDebug)
		System.out.println("getDocumentRootResourceStream: " + resource);
	
	InputStream is= null;
	if (fgDocumentRoot != null) {
		File file= new File(fgDocumentRoot + FILESEP + resource);
		try {
			// Check access violation in directories higher than fgDocumentRoot
			if (file.getCanonicalPath().toLowerCase().startsWith(fgDocumentRoot.toLowerCase())) {
				if (!file.getCanonicalPath().endsWith(new File(resource).getPath())) {
					if (isCaseWarningActivated())
						System.out.println("HttpServer case-sensitive WARNING: " + resource + " should be: " + file.getCanonicalPath());
					if (!isUnixEmulationActivated())
						is= new BufferedInputStream(new FileInputStream(file.getCanonicalPath()));
				}
				else
					is= new BufferedInputStream(new FileInputStream(file.getCanonicalPath()));
			}
			else
				System.out.println("HttpServer WARNING: Access to file higher than document root requested: DENIED");
		}
		catch (IOException e) {}
	}
	if (is == null && fgDebug)
		System.out.println("--- not found via document root");
	return is;
}
/**
 * @return java.io.InputStream
 * @param resource java.lang.String
 */
public static InputStream getResourceStream(String resource) {
	if (fgDebug)
		System.out.println("getResourceStream: " + resource);

	// First try the resources directory of the HttpServer
	InputStream is= HttpServer.class.getResourceAsStream("resources/" + resource);
	if (is != null)
		return is;
	if (fgDebug)
		System.out.println("--- not found in HttpServer's resources directory");

	// Second, try the loading as normal resource
	is= HttpServer.class.getResourceAsStream(resource);
	if (is != null)
		return is;
	if (fgDebug)
		System.out.println("--- not found as normal resource");

	// Last, try loading the resouce with absolute path
	is= HttpServer.class.getResourceAsStream("/" + resource);
	if (is == null && fgDebug)
		System.out.println("--- not found as absolute resource");
	return is;
}
public static InputStream getStreamFor(String resource) {
	// First look in document root
	InputStream is= getDocumentRootResourceStream(resource);
	if (is != null || !useResources())
		return is;
	
	// Second, try loading as resource
	is= getResourceStream(resource);
	if (is != null)
		return is;

	// Last, try loading as system resource
	is= getSystemResourceStream(resource);
	return is;
}
/**
 * @return java.io.InputStream
 * @param resource java.lang.String
 */
public static InputStream getSystemResourceStream(String resource) {
	if (fgDebug)
		System.out.println("getSystemResourceStream: " + resource);

	// Relative
	InputStream is = HttpServer.class.getClassLoader().getSystemResourceAsStream(resource);
	if (is != null)
		return is;
	if (fgDebug)
		System.out.println("--- not found as relative system resource");

	// Absolute
	is = HttpServer.class.getClassLoader().getSystemResourceAsStream("/" + resource);
	if (is == null & fgDebug)
		System.out.println("--- not found as absolute system resource");
	return is;
}
public static boolean isCaseWarningActivated() {
	return fgCaseWarning;
}
public static boolean isUnixEmulationActivated() {
	return fgEmulateUnix;
}
public static void main(String args[]) {
	HttpServer server = new HttpServer(args);
	fgDebug = server.fDebug;
	int port = 80;
	boolean winConsole = false;
	for (int i = 0; i < args.length; i++) {
		if (args[i].startsWith("-")) {
			if (args[i].equals("-wincon")) 
				winConsole = true;
			else if (args[i].equals("-caseWarning")) 
				fgCaseWarning= true;
			else if (args[i].equals("-unix")) 
				fgEmulateUnix= true;
			else if (args[i].equals("-noResources")) 
				fgNoResources= true;
			else if (args[i].equals("-debug"))
				fgDebug= true;
			else
				System.out.println("HttpServer WARNING: Illegal option: " + args[i]);
		}
		else
			port = Integer.parseInt(args[i]);
	}
	if (winConsole)
		UlcConsole.createConsole("ULC HttpServer Console", new Point(10,10));
	// load properties
	try {
		InputStream props= HttpServer.class.getResourceAsStream("/HttpServer.properties");
		if (props == null) {
			System.out.println("HttpServer: cannot load properties!");
			System.exit(1);
		}
		fgProperties.load(props);
	} catch (IOException e) {
		System.out.println("HttpServer: cannot load properties: " + e);
		System.exit(1);
	}
	try {
		String docRoot= fgProperties.getProperty("HttpServer.documentroot");
		if (docRoot != null && docRoot.length() > 0)
			fgDocumentRoot= new File(docRoot).getCanonicalPath();
	} catch (IOException ex) {
		System.out.println("HttpServer: cannot create document root path");
	}
	// Informational message to console
	System.out.println("starting http server on port: " + port);
		
	if (server.fDebug) {
		SecurityManager security = System.getSecurityManager();
		if (security == null)
			System.out.println("no SecurityManager!");
		else
			System.out.println("SecurityManager installed!");
		System.getProperties().list(System.out);
		System.out.println("user.dir = " + System.getProperty("user.dir"));
		System.out.println("java.class.path = " + System.getProperty("java.class.path"));
		test("uiengine.jar");
		test("start.html");
		test("UIApplet/UIApplet.class");
	}
	server.start("ulc://localhost:" + port);	// run as HTTP server
}
/**
 * This method was created in VisualAge.
 * @param res java.lang.String
 */
static void test(String res) {
	InputStream is = null;
	URL url = null;
	System.out.println();
	System.out.println("***** " + res + ": ");
	is= getDocumentRootResourceStream(res);
	if (is != null) {
		try {is.close();} catch (IOException e) {};
		System.out.println("+++++ could open via document root");
	}
	is= getResourceStream(res);
	if (is != null) {
		try {is.close();} catch (IOException e) {};
		System.out.println("+++++ could open as resource");
	}
	is= getSystemResourceStream(res);
	if (is != null) {
		try {is.close();} catch (IOException e) {};
		System.out.println("+++++ could open as system resource");
	}
}
public static boolean useResources() {
	return !fgNoResources;
}
}
