package com.ibm.ulc.AppController;

/*
 * Copyright (c) 1998 Object Technology International Inc.
 */


import java.util.*;
import java.io.*;
import java.net.*;
import com.ibm.ulc.application.ULCIcon;
import com.ibm.ulc.application.ULC;


class PropertyManager {

	static PropertyManager fgManager = null;   // singelton
	
	Properties fProperties = null;
	Application fDefaultApp = null;
	Application fApps[] = null;
	int fAppCount = 0;

	private PropertyManager() {
	}
	int getAppCount() {
		return fAppCount;
	}
	Application[] getApps() {
		return fApps;
	}
	Application getDefaultApp() {
		return fDefaultApp;
	}
	static synchronized PropertyManager getManager() {
		if (fgManager == null) {
			fgManager = new PropertyManager();
		}
		return fgManager;
	}
synchronized boolean loadProperties() {
	// read property file
	fProperties = new Properties();
	try {
		InputStream props = AppController.getAbsoluteResourceStream("AppController.properties");
		if (props == null) {
			System.out.println("AppController: cannot load properties!");
			return false;
		}
		fProperties.load(props);
	}
	catch (IOException e) {
		System.out.println("AppController: cannot load properties: " + e);
		return false;
	}
	if (ULC.fgDebug)
		fProperties.list(System.out);

	// get general configuation properties
	String ulcHome = fProperties.getProperty("Ulc.runtime.home");
	if (ulcHome == null) {
		System.out.println("AppController: no ULC runtime home!");
		return false;
	}

	// get default properties
	fDefaultApp = new Application();
	fDefaultApp.fConnected = Application.NOT_CONNECTED;
	fDefaultApp.fServerRunning = false;
	fDefaultApp.fLabel = fProperties.getProperty("UlcDefault.label", "***missing***");
	fDefaultApp.fIcon = new ULCIcon(AppController.class.getResource("/defaultAppIcon.gif"));
	fDefaultApp.fLanguage = fProperties.getProperty("UlcDefault.lang", "java");
	fDefaultApp.fJavaAppHome = ulcHome + AppController.FILESEP + fProperties.getProperty("UlcDefault.java.apphome", ".");
	fDefaultApp.fSmalltalkAppHome = ulcHome + AppController.FILESEP + fProperties.getProperty("UlcDefault.smalltalk.apphome", ".");
	fDefaultApp.fAppDir = fProperties.getProperty("UlcDefault.appdir", ".");
	if (fDefaultApp.fLanguage.equals("java")) {
		fDefaultApp.fAbsAppDir = fDefaultApp.fJavaAppHome + AppController.FILESEP + fDefaultApp.fAppDir;
	}
	if (fDefaultApp.fLanguage.equals("smalltalk")) {
		fDefaultApp.fAbsAppDir = fDefaultApp.fSmalltalkAppHome + AppController.FILESEP + fDefaultApp.fAppDir;
	}
	fDefaultApp.fJavaMainClass = null;
	fDefaultApp.fSmalltalkExe = null;
	String defurl = fProperties.getProperty("UlcDefault.url");
	if (defurl == null)
		fDefaultApp.fUrlString = AppController.fgDefaultUrlString;
	else
		fDefaultApp.fUrlString = mergeUrl(AppController.fgDefaultUrlString, defurl);

	// get application names
	String apps = fProperties.getProperty("ulc.applications");
	if (apps == null) {
		System.out.println("**** AppController: Missing property: ulc.applications");
		return false;
	}
	apps.trim();

	// get properties of specified applications
	StringTokenizer st = new StringTokenizer(apps, AppController.APPDELIMITERS);
	fAppCount = st.countTokens();
	fApps = new Application[fAppCount];
	for (int i = 0; st.hasMoreTokens(); i++) {
		fApps[i] = new Application();
		String id = st.nextToken();
		fApps[i].fLabel = fProperties.getProperty(id + ".label", id);
		fApps[i].fLanguage = fProperties.getProperty(id + ".lang", fDefaultApp.fLanguage);
		String home = fProperties.getProperty(id + ".java.apphome");
		if (home == null)
			fApps[i].fJavaAppHome = fDefaultApp.fJavaAppHome;
		else
			fApps[i].fJavaAppHome = ulcHome + AppController.FILESEP + home;
		home = fProperties.getProperty(id + ".smalltalk.apphome");
		if (home == null)
			fApps[i].fSmalltalkAppHome = fDefaultApp.fSmalltalkAppHome;
		else
			fApps[i].fSmalltalkAppHome = ulcHome + AppController.FILESEP + home;
		fApps[i].fAppDir = fProperties.getProperty(id + ".appdir", fDefaultApp.fAppDir);
		if (fApps[i].fLanguage.equals("java")) {
			fApps[i].fJavaMainClass = fProperties.getProperty(id + ".mainclass", "");
			fApps[i].fSmalltalkExe = null;
			fApps[i].fAbsAppDir = fApps[i].fJavaAppHome + AppController.FILESEP + fApps[i].fAppDir;
		}
		if (fApps[i].fLanguage.equals("smalltalk")) {
			fApps[i].fJavaMainClass = null;
			fApps[i].fSmalltalkExe = fProperties.getProperty(id + ".exec", "");
			fApps[i].fAbsAppDir = fApps[i].fSmalltalkAppHome + AppController.FILESEP + fApps[i].fAppDir;
		}
		String url = fProperties.getProperty(id + ".url");
		if (url == null)
			fApps[i].fUrlString = fDefaultApp.fUrlString;
		else
			fApps[i].fUrlString = mergeUrl(fDefaultApp.fUrlString, url);
		String iconPath = fProperties.getProperty(id + ".icon");
		if (iconPath != null) {
			iconPath = fApps[i].fAbsAppDir + AppController.FILESEP + iconPath;
			try {
				URL iconUrl = new URL("file", "", iconPath);
				try {
					InputStream stream = iconUrl.openStream();
					stream.close();
					fApps[i].fIcon = new ULCIcon(iconUrl);
				}
				catch (IOException e) {
					System.out.println("@@@ AppController: Invalid path for icon file " + id + " url: " + iconUrl.toString() + " (using default)");
					fApps[i].fIcon = fDefaultApp.fIcon;
				}
			}
			catch (MalformedURLException mue) {
				System.out.println("@@@ AppController: Invalid path for icon file " + id + " (using default)");
				fApps[i].fIcon = fDefaultApp.fIcon;
			}
		}
		else
			fApps[i].fIcon = fDefaultApp.fIcon;
	}
	return true;
}
private String mergeUrl(String baseUrlString, String urlString) {
	// Fill in missing pieces in partial URL spec url from baseUrl
	// assumption: baseUrl is complete.
	String resultUrlString = null;
	String validBaseUrlString = null;
	String protoBase = null;
	int ind1 = baseUrlString.indexOf(":");
	validBaseUrlString = "http" + baseUrlString.substring(ind1);
	protoBase = baseUrlString.substring(0,ind1);
	String validUrlString = urlString;
	String proto = protoBase;
	ind1 = urlString.indexOf(":");
	int ind2 = urlString.indexOf("/");
	if (ind1 >= 0 && ind1 < ind2) {
		validUrlString = "http" + urlString.substring(ind1);
		proto = urlString.substring(0,ind1);
	}		

	try {
		URL baseUrl = new URL(validBaseUrlString);
		URL url = new URL(baseUrl,validUrlString);
		resultUrlString = url.toString();
		ind1 = resultUrlString.indexOf(":");
		resultUrlString = proto + resultUrlString.substring(ind1);
	} catch (MalformedURLException mue) {
		resultUrlString = baseUrlString;
	}

	return resultUrlString;
}
}
