"2000.02.25"
	| importBlock sourceFixMapName sourceFixTS sourceLibrary destLibrary srcFile currentUser |
	
	sourceFixMapName := 'AbtSourceFix'.
	sourceFixTS := EmTimeStamp new: 3127740002.
	currentUser := EmUser current.

	importBlock := [:srcLibrary :dstLibrary |
		| theMap |
		theMap :=
			(EmConfigurationMap editionsFor: sourceFixMapName)
				detect: [ : edition | edition timeStamp = sourceFixTS ]
				ifNone: [nil].

		(theMap notNil)
			ifTrue: 
				[
				AbtCommonFeatureInstaller
					logMessage: ( 'anyObj' 
						getMsg: AbtFeatureLoadGrp::AbtInsTeamMapVersion
						group: 'AbtFeatureLoadGrp' 
						with: theMap signature)
					prompting: false.
				EtTools managerInterface
					moveConfigMaps: (Array with: theMap)
					from: srcLibrary
					to: dstLibrary
					withOptions: #()
					withAllRequiredMaps: false.

				]

			ifFalse: 

				[
				AbtCommonFeatureInstaller 
					logMessage: ( 'anyObj' 
							getMsg: AbtFeatureLoadGrp::AbtInsTeamMapNotFound
							group: 'AbtFeatureLoadGrp'
							with: sourceFixMapName
							with: sourceFixTS
							with: srcLibrary fullName
						) 
					prompting: false.
				] "ifFalse"

		]. "importBlock"

	srcFile := AbtCommonProductInstallerApp importDirectory  "Must already include trailing path separator"
		, '501_sfix.dat'.

	sourceLibrary :=
		EmLibrary
			open: srcFile
			singleUserMode: EmLibrary singleUserMode
			initialReadSize: EmLibrary initialReadSize
			serverAddress: AbtCommonProductInstallerApp importServerAddress.

	destLibrary := EmLibrary default.

	System
		execute: 
			[
			EmMethodEdition importSource: true.
			EmLibrary default: sourceLibrary.
			[ importBlock value: sourceLibrary value: destLibrary ] 
				atEndOrWhenExceptionDo:
					[ EmMethodEdition importSource: false].

			]
		onReturn: 
			[
			EmLibrary default: destLibrary.
			EmUser allUsers.
			(EmUser classPool declareVariable: 'CurrentUser') value: currentUser.
			sourceLibrary close
			].

!
