EpImageDumping becomeDefault!

!BlockContextTemplate privateMethods !

epNativeStartPC

 "Answer the nativeStartPC of the receiver."

 ^nativeStartPC!

epNativeStartPC: anObject

 "Set the nativeStartPC of the receiver to anObject."

 nativeStartPC := anObject.! !

BlockContextTemplate categoriesFor: #epNativeStartPC are:   
#('EP-Internal')!
BlockContextTemplate categoriesFor: #epNativeStartPC: are:   
#('EP-Internal')!

!EpImage privateMethods !

copyMethod: method compact: compact

 "Answer a copy of method, which shares the instance variables."

 | newCm literal newBct |
 (compact and: [self createIC]) ifTrue: [
  (newCm := EpCompactMethod new)
   methodId: method methodId;
   bytecodes: (EsByteCodeArray uncompressBytecodeArray: method bytecodes   
copy).
  1 to: method size do: [:i |
   (literal := method at: i) epIsBCT ifTrue: [
    newBct := self uncompressContext: literal methodContext: newCm.
    (self templates at: newCm ifAbsentPut: [OrderedCollection new]) add:   
newBct.
    translate at: literal put: newBct.
   ].
  ].
 ] ifFalse: [
  (newCm := CompiledMethod new: method size)
   bytecodes: (EsByteCodeArray uncompressBytecodeArray: method bytecodes   
copy);
   methodClass: method methodClass;
   selector: method selector;
   filePointer: method filePointer.
  1 to: method size do: [:i |
   (literal := method at: i) epIsBCT ifTrue: [
    newBct := self uncompressContext: literal methodContext: newCm.
    self templates notNil ifTrue: [
     (self templates at: newCm ifAbsentPut: [OrderedCollection new]) add:   
newBct].
    literal := translate at: literal put: newBct.
   ].
   newCm at: i put: literal].
  ].
 ^newCm!

prepareToPackage

 | apps subclasses rules system |

 self
  mapClass: (self globalNamespace classAt: #Process) to: Exclude;
  mapClass: (self globalNamespace classAt: #EsCompactMethod) to: Exclude;
  mapClass: (self globalNamespace classAt: #MethodContext) to: Include;
  mapClass: (self globalNamespace classAt: #BlockContext) to: Exclude.

 self mapGlobals.
 self isRunningImage ifTrue: [
  "Handle the development image specially since the accessors do not
   answer the Array stored in the image. Send the accessors in case the
   collections need to be recomputed."
  System loadedApplications; loadedSubApplications.
  self removeUnpackagedClassesFrom: Application primitiveCurrentlyLoaded.
  apps := self removeUnpackagedClassesFrom: SubApplication   
primitiveCurrentlyLoaded.
  self packagedSubApplications: apps.

  (CgServer respondsTo: #serverClasses) ifTrue: [
   self removeUnpackagedClassesFrom: CgServer serverClasses].
 ] ifFalse: [
  self removeUnpackagedClassesFrom: self loadedApplications.
  apps := self removeUnpackagedClassesFrom: self loadedSubApplications.
  self packagedSubApplications: apps.
 ].

 uncompressedIds := EpLargeIdentitySet new.

 totalCms := 0.
 collapsedVariables := EpImage smallDictionary new.
 self localSteps: System allClasses size.
 subclasses := self mapClasses: self image classHierarchyRoots   
superRules: (Array
  with: self class defaultClassRule
  with: (self instanceVariableRulesFor: self classClass using: nil)   
contents
  with: nil).
 abort ifTrue: [^self].

 "Fix Class subclasses to include metaclasses of subclasses of nil."
 translate at: self classClass subclasses put:
  (((translate at: self classClass subclasses) asSortedCollection: Class   
sortBlock)
   addAll: (subclasses collect: [:cl | cl class]);
   asArray).
 collapsedVariables := nil.

 self isRunningImage ifFalse: [

  self
   initializePassiveStartup;
   initializePassiveImageMappings.

  #(EmXDClass EmXDMetaclass) do: [:className |
   | class |
   (class := Smalltalk classAt: className) instVarNames do: [:varName |
    self mapVariable: varName in: class to: Remove].
   self
    generateTraversingMethodFor: class using:
     (rules := self instanceVariableRulesFor: class using: nil);
    generateDumpingMethodsFor: class using: rules.
  ].
  #(#EmXDApplication #EmXDSubApplication) do: [:className |
   | class |
   (class := Smalltalk classAt: className) class instVarNames do:   
[:varName |
    self mapVariable: varName in: class class to: Remove].
   self
    generateTraversingMethodFor: class class using:
     (rules := self instanceVariableRulesFor: class class using: nil);
    generateDumpingMethodsFor: class class using: rules.
  ].

  #(EmSelectorInformation EmExtendedClassInformation EmTimeStamp   
EmShadowClass EmShadowMetaclass)
  do: [:className |
   (self globalNamespace includesKey: className) ifFalse: [
    self traverse: (Smalltalk classAt: className) using: Exclude]].
 ].
 self initializeAssociation.

 (system := translate at: System ifAbsent: [translate at: System put:   
System copy])
  startUpClass: self startUpClass.

"
 self snapshotID notNil ifTrue: [
  system snapshotId: self snapshotID].
"!

translateContext: bct

 | cm newCm cmSize newBct |
 (cm := bct method) class == EsCompactMethod ifTrue: [
  (uncompressedIds includes: cm methodId) ifTrue: [
   newCm := (methodDictionaries at: cm methodClass) at: cm selector.
  ] ifFalse: [
   newCm := uncompressedMethods at: cm methodId ifAbsentPut: [self   
copyMethod: cm compact: true].
   "Check if the context was translated by #copyMethod:compact:."
   (translate includesKey: bct) ifTrue: [^true].
  ].
  newBct := self uncompressContext: bct methodContext:
   (bct epMethodContext isInteger ifTrue: [newCm] ifFalse: [bct   
epMethodContext]).
  self templates notNil ifTrue: [
   (self templates at: newCm ifAbsentPut: [OrderedCollection new]) add:   
newBct].
  translate at: bct put: newBct ifPresent: [
   self errorMessage: (NlsCatEPe indexedMsg: 28)].    "$NLS$ Duplicate   
replacement"
 ] ifFalse: [
  self compressCode ifTrue: [
   cmSize := cm size - (cm hasFilePointer ifTrue: [1] ifFalse: [0]).
   newBct := EsCompactBlockContextTemplate new
    methodContext: bct epMethodContext;
    epParent: bct parent;
    startPC: (bct climStartPC * 2 - 12) + (8 + (cmSize * 4)) // 2 - 1;
    argsAndTemps: bct climArgsAndTemps;
    epNativeStartPC: self;  "Mark the context as converted."
    yourself.
   (self templates at: cm ifAbsentPut: [OrderedCollection new]) add:   
newBct.
   translate at: bct put: newBct
    ifPresent: [self errorMessage: (NlsCatEPe indexedMsg: 28)].    "$NLS$   
Duplicate replacement"
  ] ifFalse: [self error: (NlsCatEPe indexedMsg: 55)].  "$NLS$ Invalid   
context"
 ].
 ^true!

translateMethodContext: context

 | cm newCm newContext |
 cm := context method.
 (uncompressedIds includes: cm methodId) ifTrue: [
  newCm := (methodDictionaries at: cm methodClass) at: cm selector.
 ] ifFalse: [
  newCm := uncompressedMethods at: cm methodId ifAbsentPut: [self   
copyMethod: cm compact: true].
 ].
 (newContext := context copy)
  epMethod: newCm.
 translate at: context put: newContext ifPresent: [
  self errorMessage: (NlsCatEPe indexedMsg: 28)].    "$NLS$ Duplicate   
replacement"
 ^true!

uncompressContext: bct methodContext: context

 | class startPC |
 self compressCode ifTrue: [
  class := EsCompactBlockContextTemplate.
  self dumperClass isWide
   ifTrue: [startPC := (bct climStartPC + 1 * 2 - bct method   
offsetToBytecodes) + (16 + (bct method size * 8)) // 2 - 1]
   ifFalse: [startPC := (bct climStartPC + 1 * 2 - bct method   
offsetToBytecodes) + (8 + (bct method size * 4)) // 2 - 1].
 ] ifFalse: [
  class := BlockContextTemplate.
  startPC := bct climStartPC + 1 * 2 - bct method offsetToBytecodes + 12   
// 2.
 ].

 ^class new
  methodContext: context;
  epParent: bct parent;
  startPC: startPC;
  argsAndTemps: bct climArgsAndTemps;
  epNativeStartPC: self;  "Mark the context as converted."
  yourself
! !

EpImage categoriesFor: #copyMethod:compact: are: #('EP-Internal')!
EpImage categoriesFor: #prepareToPackage are: #('EP-Internal')!
EpImage categoriesFor: #translateContext: are: #('EP-Internal')!
EpImage categoriesFor: #translateMethodContext: are: #('EP-Internal')!
EpImage categoriesFor: #uncompressContext:methodContext: are:   
#('EP-Internal')!

!EsImageDumper privateMethods !

addIncludedObject: anObject in: determinedSpace
 "Add anObject to space determinedSpace. Add the object to
  the queue of objects to be traversed. This is slower than
  traversing it immediately, but reduces the chance of there
  being a stack overflow."

 | assoc |

 "If the object has already been written out, then don't
  write it out again."
 (objects includesKey: anObject) ifTrue: [^self].

 "Remember the space for a translated object."
 (self translate: anObject in: determinedSpace)
  ifTrue: [^self].

 anObject class == BlockContextTemplate ifTrue: [
  ((image compressCode or: [anObject method class == EsCompactMethod])   
and: [
   anObject epNativeStartPC ~~ image])
  ifTrue: [
   (image translateContext: anObject) ifTrue: [
    ^self translate: anObject in: determinedSpace]]].

 anObject class == EsCompactBlockContextTemplate ifTrue: [
  (anObject method class == EsCompactMethod and: [anObject   
epNativeStartPC ~~ image]) ifTrue: [
   (image translateContext: anObject) ifTrue: [
    ^self translate: anObject in: determinedSpace]]].

 anObject class == MethodContext ifTrue: [
  anObject method class == EsCompactMethod ifTrue: [
   (image translateMethodContext: anObject) ifTrue: [
    ^self translate: anObject in: determinedSpace]]].

 image isRunningImage ifFalse: [
  (translate keyIfAbsentAt: anObject PackagerClass) owningImage == image   
image ifFalse: [
   "Exclude instances of classes which are not mapped to a passive   
class."
   ^excludedInstances add: anObject]].

 (anObject PackagerClass PackagerClass == image metaclassClass and: [
  "Filter instances of EmShadowSubApplication class and   
EmShadowApplication class."
  anObject PackagerClass symbol == anObject symbol])
 ifTrue: [
  anObject isRemoved ifTrue: [^self].
  self addObject: anObject PackagerClass in: determinedSpace.
  smalltalk == nil ifFalse: [
   (assoc := image globalNamespace associationAt: anObject symbol   
ifAbsent: []) notNil
    ifTrue: [(self namespaceFor: assoc) add: assoc]]].

 "Add the object to instanceSpace."
 objects at: anObject put: determinedSpace.

 (anObject isAssociation and: [
  anObject key class == String or: [anObject key class == Symbol]])
 ifTrue: [associations at: anObject put: determinedSpace].

 anObject PackagerClass isPointers ifTrue: [
  toBeDumped add: anObject].! !

EsImageDumper categoriesFor: #addIncludedObject:in: are:   
#('EP-Internal')!

!MethodContext privateMethods !

epMethod: anObject

 "Set the method of the receiver to anObject."

 method := anObject.! !

MethodContext categoriesFor: #epMethod: are: #('EP-Internal')!

!EsDumper privateMethods !

addIncludedObject: anObject in: determinedSpace
 "Add anObject to space determinedSpace. Add the object to
  the queue of objects to be traversed. This is slower than
  traversing it immediately, but reduces the chance of there
  being a stack overflow."

 | instanceSpace propogateSpace assoc space |

 "If the object has already been written out, then don't
  write it out again."

 (instanceSpace := instanceMaps at: anObject ifAbsent: []) isNil ifTrue:   
[
  instanceSpace := determinedSpace].
 propogateSpace := instanceSpace propogate
  ifTrue: [instanceSpace] ifFalse: [determinedSpace].
 (space := objects keyIfAbsentAt: anObject) == anObject ifFalse: [
  ^space epIsOutputDesignation ifTrue: [
   (instanceSpace isUnspecified or: [instanceSpace == space]) ifTrue:   
[^self].
   (space isUnspecified or: [instanceSpace priority > space priority])   
ifTrue: [
    (anObject isAssociation and: [
     anObject key class == String or: [anObject key class == Symbol]])
    ifTrue: [associations at: anObject put: propogateSpace].

    objects at: anObject put: instanceSpace.
    anObject PackagerClass isPointers ifTrue: [
     toBeDumped
      add: anObject;
      add: propogateSpace.
    ].
   ] ifFalse: [
    instanceSpace priority = space priority
     ifTrue: [self error: (NlsCatEPa indexedMsg: 10)].    "$NLS$ Space   
conflict"
   ]]].

 "Remember the space for a translated object."
 (self translate: anObject in: instanceSpace)
  ifTrue: [^self].

 anObject class == BlockContextTemplate ifTrue: [
  ((image compressCode or: [anObject method class == EsCompactMethod])   
and: [
   anObject epNativeStartPC ~~ image])
  ifTrue: [
   (image translateContext: anObject) ifTrue: [
    ^self translate: anObject in: instanceSpace]]].

 anObject class == EsCompactBlockContextTemplate ifTrue: [
  (anObject method class == EsCompactMethod and: [anObject   
epNativeStartPC ~~ image]) ifTrue: [
   (image translateContext: anObject) ifTrue: [
    ^self translate: anObject in: instanceSpace]]].

 anObject class == MethodContext ifTrue: [
  anObject method class == EsCompactMethod ifTrue: [
   (image translateMethodContext: anObject) ifTrue: [
    ^self translate: anObject in: instanceSpace]]].

 image isRunningImage ifFalse: [
  (translate keyIfAbsentAt: anObject PackagerClass) owningImage == image   
image ifFalse: [
   "Exclude instances of classes which are not mapped to a passive   
class."
   ^excludedInstances add: anObject]].

 self useROMequals ifTrue: [
  (self isROMequal: anObject in: instanceSpace) ifTrue: [^self]].

 instanceSpace epIsROMSpace ifTrue: [
  objectsInROM at: anObject PackagerClass ifPresent: [:inROM |
   | uniqueElement |
   (uniqueElement := inROM epElementAt: anObject) notNil ifTrue: [
    translate at: anObject put: uniqueElement.
    ^self addIncludedObject: uniqueElement in: instanceSpace]
   ifFalse: [inROM add: anObject]
  ].
 ].

 (anObject PackagerClass PackagerClass == image metaclassClass and: [
  "Filter instances of EmShadowSubApplication class and   
EmShadowApplication class."
  (translate keyIfAbsentAt: anObject PackagerClass primaryInstance) ==   
anObject])
 ifTrue: [
  anObject isRemoved ifTrue: [^self].
  self addObject: (translate keyIfAbsentAt: anObject PackagerClass) in:   
propogateSpace.
  smalltalk == nil ifFalse: [
   (assoc := image globalNamespace associationAt: anObject symbol   
ifAbsent: []) notNil
    ifTrue: [(self namespaceFor: assoc) add: assoc]]].

 "Add the object to instanceSpace."
 objects at: anObject put: instanceSpace.

 (anObject isAssociation and: [
  anObject key class == String or: [anObject key class == Symbol]])
 ifTrue: [associations at: anObject put: propogateSpace].

 anObject PackagerClass isPointers ifTrue: [
  toBeDumped
   add: anObject;
   add: propogateSpace.
 ].
! !

EsDumper categoriesFor: #addIncludedObject:in: are: #('EP-Internal')!