/* */
/********************************************************************

NAME:      do-what.cmd levelFileList includeFileBaseName

SAMPLE INVOCATION:
  rexx do-what.cmd master.list what-info

PURPOSE:
 To prepare the following include files with the information
 of the serviceability strings specified in the levelListFile argument
 (such as level.list).
   * include header file, such as what-info.h
   * include source file, such as what-info.c
   * include source file for standalone level application,
     such as what-info-level.c

CUSTOMIZATION NOTES:
 * You may want to customize this script to suit your needs. There are
   some sections that are labeled "CUSTOMIZATION NEEDED". For example:
   * Replace the value for the "keyword" variable to identify
     your application.

*********************************************************************/

/* CUSTOMIZATION NEEDED.                            */
/* Set the keyword to be used during what and grep. */

keyword="myApp"

/* Verify the input parameters */

parse arg levelListFile includeFileBaseName .
usage = " usage: rexx do-what.cmd levelListFile includeFileBaseName"

/* Do the processing only if all variables are specified */

if (levelListFile="") | (includeFileBaseName="") then
do
  say "*** Error: parameters missing"
  say usage
  exit 1
end

say "do-what.cmd: begin"

/* Open input file */
rcFile = stream( levelListFile, C, 'open read' )
if ( rcFile \= "READY:" ) then
do
   say "*** Error while trying to open file: " levelListFile
   say "    The return code is: " rcFile
   say "    Exiting now."
   exit 1
end

/* Open output file: header file */
includeHeaderFile = includeFileBaseName || ".h"
rcFile = stream( includeHeaderFile, C, 'open write' )
if ( rcFile \= "READY:" ) then
do
   say "*** Error while trying to open file: " includeHeaderFile
   say "    The return code is: " rcFile
   say "    Exiting now."
   exit 1
end

/* Open output file: generic source file */
includeSourceFile = includeFileBaseName || ".c"
rcFile = stream( includeSourceFile, C, 'open write' )
if ( rcFile \= "READY:" ) then
do
   say "*** Error while trying to open file: " includeSourceFile
   say "    The return code is: " rcFile
   say "    Exiting now."
   exit 1
end

/* Open output file: level source file */
includeSourceLevelFile = includeFileBaseName || "-level.c"
rcFile = stream( includeSourceLevelFile, C, 'open write' )
if ( rcFile \= "READY:" ) then
do
   say "*** Error while trying to open file: " includeSourceLevelFile
   say "    The return code is: " rcFile
   say "    Exiting now."
   exit 1
end

/********* Create the output include header file ************/

say ""
say "do-what.cmd: generating include header file: " includeHeaderFile

outLine = '/* Name:  ' includeHeaderFile ' */'
temp = LINEOUT(includeHeaderFile, outLine);
outLine = '/* Purpose:  This file is generated during build time.  */'
temp = LINEOUT(includeHeaderFile, outLine);
outLine = '/*   It has the "build-time" serviceability information. */'
temp = LINEOUT(includeHeaderFile, outLine);
outLine = '/*   to be displayed by using the what utility.          */'
temp = LINEOUT(includeHeaderFile, outLine);
outLine = ''
temp = LINEOUT(includeHeaderFile, outLine);

outLine = '#ifndef _WHAT_INFO_H_'
temp = LINEOUT(includeHeaderFile, outLine);
outLine = '#define _WHAT_INFO_H_'
temp = LINEOUT(includeHeaderFile, outLine);
outLine = ''
temp = LINEOUT(includeHeaderFile, outLine);

DO UNTIL ( LINES( levelListFile ) = 0 )   /* Read until the end of file */
  pair = LINEIN( levelListFile )
  PARSE VAR pair variableName variableValue
  outLine="char " variableName"[] = ""@(#) " keyword variableValue " "";"
  temp = LINEOUT(includeHeaderFile, outLine)
END  /* do until */
                                          
outLine = '#endif'
temp = LINEOUT(includeHeaderFile, outLine);

outLine = ''
temp = LINEOUT(includeHeaderFile, outLine);

outLine = '/* end of file */'
temp = LINEOUT(includeHeaderFile, outLine);

rc = STREAM(includeHeaderFile, C, 'close');
rc = STREAM(levelListFile, C, 'close');

say "do-what.cmd: the include header file " includeHeaderFile " is now ready!"
  

/********* Create the output include generic source file ************/

/* Open input file */
rcFile = stream( levelListFile, C, 'open read' )
if ( rcFile \= "READY:" ) then
do
   say "*** Error while trying to open file: " levelListFile
   say "    The return code is: " rcFile
   say "    Exiting now."
   exit 1
end

say ""
say "do-what.cmd: generating include generic source file: " includeSourceFile

outLine = '/* Name:  ' includeSourceFile ' */'
temp = LINEOUT(includeSourceFile, outLine);
outLine = '/* Purpose:  This file is generated during build time.    */'
temp = LINEOUT(includeSourceFile, outLine);
outLine = '/*   It has the "build-time" serviceability information.  */'
temp = LINEOUT(includeSourceFile, outLine);
outLine = '/*   to be displayed by using the what utility.           */'
temp = LINEOUT(includeSourceFile, outLine);
outLine = "/* Note: It is necessary to declare and use the variables */"
temp = LINEOUT(includeSourceFile, outLine);
outLine = "/*       in order to fool the compiler; otherwise, the    */"
temp = LINEOUT(includeSourceFile, outLine);
outLine = "/*       compiler will remove them from the executable.   */"
temp = LINEOUT(includeSourceFile, outLine);
outLine = ''
temp = LINEOUT(includeSourceFile, outLine);

outLine = "int dummy=3;      /* Set to a number different than -7077 */"
temp = LINEOUT(includeSourceFile, outLine);
outLine = "char dummyString[2000]; "
temp = LINEOUT(includeSourceFile, outLine);
outLine = ""

DO UNTIL ( LINES( levelListFile ) = 0 )   /* Read until the end of file */
  pair = LINEIN( levelListFile )
  PARSE VAR pair variableName variableValue
  outLine="strcpy(dummyString," variableName "); "
  temp = LINEOUT(includeSourceFile, outLine)
END  /* do until */

outLine = ''
temp = LINEOUT(includeSourceFile, outLine);
outLine = "if (dummy == -7077) {"
temp = LINEOUT(includeSourceFile, outLine);
outLine = "   printf(""%s"",dummyString);"
temp = LINEOUT(includeSourceFile, outLine);
outLine = "}"
temp = LINEOUT(includeSourceFile, outLine);

outLine = ''
temp = LINEOUT(includeSourceFile, outLine);
outLine = '/* end of file */'
temp = LINEOUT(includeSourceFile, outLine);

rc = STREAM(includeSourceFile, C, 'close');
rc = STREAM(levelListFile, C, 'close');

say "do-what.cmd: the include source file " includeSourceFile " is now ready!"


/********* Create the output include level source file ************/

/* Open input file */
rcFile = stream( levelListFile, C, 'open read' )
if ( rcFile \= "READY:" ) then
do
   say "*** Error while trying to open file: " levelListFile
   say "    The return code is: " rcFile
   say "    Exiting now."
   exit 1
end

say ""
say "do-what.cmd: generating include level source file: " includeSourceLevelFile

outLine = '/* Name:  ' includeSourceLevelFile ' */'
temp = LINEOUT(includeSourceLevelFile, outLine);
outLine = '/* Purpose:  This file is generated during build time.    */'
temp = LINEOUT(includeSourceLevelFile, outLine);
outLine = '/*   It has the "build-time" serviceability information.  */'
temp = LINEOUT(includeSourceLevelFile, outLine);
outLine = '/*   to be displayed by the standalone level application */'
temp = LINEOUT(includeSourceLevelFile, outLine);
outLine = ''
temp = LINEOUT(includeSourceLevelFile, outLine);

DO UNTIL ( LINES( levelListFile ) = 0 )   /* Read until the end of file */
  pair = LINEIN( levelListFile )
  PARSE VAR pair variableName variableValue
  outLine="printf(""%s\n""," variableName "); "
  temp = LINEOUT(includeSourceLevelFile, outLine)
END  /* do until */

outLine = ''
temp = LINEOUT(includeSourceLevelFile, outLine);
outLine = '/* end of file */'
temp = LINEOUT(includeSourceLevelFile, outLine);

rc = STREAM(includeSourceLevelFile, C, 'close');
rc = STREAM(levelListFile, C, 'close');

say "do-what.cmd: the include source file " includeSourceLevelFile " is now ready!"

say "do-what.cmd: done!"

exit 0

/* end of file */

