/* */
/********************************************************************

NAME:      do-what.cmd levelFileList includeFileBaseName

SAMPLE INVOCATION:
  rexx do-what.cmd master.list whatInfo

PURPOSE:
To generate the java class whatInfo which will be instantiated
by both the myapp and myapplevel applications.  The "report"
method will be used to display all the serviceability strings.

CUSTOMIZATION NOTES:
 * You may want to customize this script to suit your needs. There are
   some sections that are labeled "CUSTOMIZATION NEEDED". For example:
   * Replace the value for the "keyword" variable to identify
     your application.

*********************************************************************/

/* CUSTOMIZATION NEEDED.                            */
/* Set the keyword to be used during what and grep. */

keyword="myapp"

/* Verify the input parameters */

parse arg levelListFile includeFileBaseName .
usage = " usage: rexx do-what.cmd levelListFile includeFileBaseName"

/* Do the processing only if all variables are specified */

if (levelListFile="") | (includeFileBaseName="") then
do
  say "*** Error: parameters missing"
  say usage
  exit 1
end

say "do-what.cmd: begin"

/* Open input file */
rcFile = stream( levelListFile, C, 'open read' )
if ( rcFile \= "READY:" ) then
do
   say "*** Error while trying to open file: " levelListFile
   say "    The return code is: " rcFile
   say "    Exiting now."
   exit 1
end

/* Open output file: */
infoFile = includeFileBaseName || ".java"
rcFile = stream( infoFile, C, 'open write' )
if ( rcFile \= "READY:" ) then
do
   say "*** Error while trying to open file: " infoFile
   say "    The return code is: " rcFile
   say "    Exiting now."
   exit 1
end


/********* Create the info java file ************/

say ""
say "do-what.cmd: generating info file: " infoFile

outLine = '// Name:  ' infoFile 
temp = LINEOUT(infoFile, outLine);
outLine = '// Purpose:  This file is generated during build time.   '
temp = LINEOUT(infoFile, outLine);
outLine = '//   It has the "build-time" serviceability information. '
temp = LINEOUT(infoFile, outLine);
outLine = '//   to be displayed by using the what utility.          '
temp = LINEOUT(infoFile, outLine);
outLine = ''
temp = LINEOUT(infoFile, outLine);

outLine = 'package ' keyword ';'
temp = LINEOUT(infoFile, outLine);
outLine = ''
temp = LINEOUT(infoFile, outLine);

outLine = 'public class ' includeFileBaseName
temp = LINEOUT(infoFile, outLine);

outLine = '{'
temp = LINEOUT(infoFile, outLine);

outLine = '  //This class is generated by do-what.ksh or do-what.cmd.  Do not modify!'
temp = LINEOUT(infoFile, outLine);

outLine = '  //VARIABLES'
temp = LINEOUT(infoFile, outLine);

DO UNTIL ( LINES( levelListFile ) = 0 )   /* Read until the end of file */
  pair = LINEIN( levelListFile )
  PARSE VAR pair variableName variableValue
  outLine = "  public String " variableName" = ""@(#) " keyword variableValue " "";"
  temp = LINEOUT(infoFile, outLine)
END  /* do until */
                 
outLine = ''
temp = LINEOUT(infoFile, outLine);

outLine = '  //METHODS'
temp = LINEOUT(infoFile, outLine);
     
outLine = '    public void report()'
temp = LINEOUT(infoFile, outLine);

outLine = '    {'
temp = LINEOUT(infoFile, outLine);

outLine = ''
temp = LINEOUT(infoFile, outLine);

rc = STREAM(levelListFile, C, 'close');
/* Open input file */
rcFile = stream( levelListFile, C, 'open read' )
if ( rcFile \= "READY:" ) then
do
   say "*** Error while trying to open file: " levelListFile
   say "    The return code is: " rcFile
   say "    Exiting now."
   exit 1
end

DO UNTIL ( LINES( levelListFile ) = 0 )   /* Read until the end of file */
  pair = LINEIN( levelListFile )
  PARSE VAR pair variableName variableValue
  outLine = "	System.out.println(this."variableName");"
  temp = LINEOUT(infoFile, outLine)
END  /* do until */


outLine = '    }//end of report()'
temp = LINEOUT(infoFile, outLine);
                    
outLine = '    }//end of' includeFileBaseName
temp = LINEOUT(infoFile, outLine);

outLine = ''
temp = LINEOUT(infoFile, outLine);

outLine = '/* end of file */'
temp = LINEOUT(infoFile, outLine);

rc = STREAM(infoFile, C, 'close');
rc = STREAM(levelListFile, C, 'close');

say "do-what.cmd: the info class file " infoFile " is now ready!"

exit 0

/* end of file */

