/* */
/********************************************************************

NAME: do-build.cmd [ debug | beta ]

SAMPLE INVOCATION:
  rexx do-build.cmd 2001-03-09 debug

PURPOSE:
 This is the top level script to build the application "myapp".

*********************************************************************/


/* Verify the input parameters */

parse arg driverName option
usage = "do-build.cmd [ debug | beta ]"

/* Do the processing for the option */

if (option = "") then
do
  FLAGS=""
end
else
do
  if (option = "debug") then
  do
     say "**********ERROR**********"
     say "Set the DEBUG variable in the java source code for myapp "
     say "to 'true' and then call this script without the debug  parameter:"
     say ""
     say "rexx do-build.cmd driverName"
     exit 1
    
  end
  else
  do
     if (option = "beta") then
     do
       say "**********ERROR**********"
       say "Set the BETA variable in the java source code for myapp "
       say "to 'true' and then call this script without the beta parameter."
       say ""
       say "rexx do-build.cmd driverName"
       exit 1
     end
     else
     do
       say "*** Error: wrong option. If specified, it must be: debug or beta"
       say usage
       exit 1
     end
  end
end



/* Section:  Invoke the make file */

say 'nmake -f myapp-w.mak all FLAGS='FLAGS''
'nmake -f myapp-w.mak all FLAGS="'FLAGS'"'
/* end of file */
