#!/usr/bin/ksh
#
# Name:    CmvcUpdateChangeView DATABASE familyName

#
# Purpose: To modify ChangeView in order to facilitate the migration
#          from CMVC to VisualAge TeamConnection Version 3.
#
# Notes:   It uses the environment variable $ORACLE_PASS
#          which has the password for the CMVC family.

# Process the proper number if input parameters
# sysbase (may need to include -U in U_STRING)

function usage
{
   print -u2 'usage:  CmvcUpdateChangeView DATABASE familyName   '
   print  "           details: DATABASE   = DB2|ORACLE|ORACLE7|SYBASE|INFORMIX"
   print  "                    familyName = CMVC Family name"
   exit 1
}

#main

if [ "$#" -ne 2 ]
  then usage
fi

print 'CmvcUpdateChangeView: Starting script ' $1 $2
LOG=CmvcUpdateChangeView.out
DATABASE=${1}
FAMILY=${2}

case "${DATABASE}" in

  ORACLE|ORACLE7|oracle|oracle7 )
    SQL="${ORACLE_HOME}/bin/sqlplus"
    U_STRING=""
    COMMIT_STRING=""
    PASSWORD_STRING="/${ORACLE_PASS}"
    SEMI_STRING=";"
    INIT_CMD="${SQL} ${U_STRING} ${FAMILY}${PASSWORD_STRING}"
    ;;

  DB2|db2 )
    SQL="${DB2_HOME}/sqllib/bin/db2"
    U_STRING=" -o -t +v"
    COMMIT_STRING=""
    PASSWORD_STRING=""
    SEMI_STRING=";"
    INIT_CMD="${SQL} ${U_STRING}"
    ;;

  INFORMIX|informix )
    SQL="${INFORMIXDIR}/bin/isql"
    U_STRING=""
    COMMIT_STRING="commit work;"
    PASSWORD_STRING=""
    SEMI_STRING=";"
    INIT_CMD="${SQL} ${U_STRING} ${FAMILY} ${PASSWORD_STRING}"
    ;;

  SYBASE|sybase )
    SQL="${SYBASE}/bin/isql"
    U_STRING=""
    COMMIT_STRING="go"
    PASSWORD_STRING=" -P ${SYBASE_PASS}"
    SEMI_STRING=""
    INIT_CMD="${SQL} ${U_STRING} ${PASSWORD_STRING}"
    ;;

  * )
    print "Unrecognized DATABASE $DATABASE" | tee -a $LOG
    usage
    ;;

esac

if [ ${DATABASE} = "DB2" -o ${DATABASE} = "db2" ]
  then
    ${SQL} connect to ${FAMILY} > $LOG  2>&1
    rc=$?
    if (( $rc > 0 ))
      then
         print "could not connect to database ${FAMILY}" | tee -a $LOG
         exit 1
    fi
fi


####### Customization notes #############################################
# Place the actual database commands inside the begin and end !!!
# Remember to put the ; (semicolon) at the end of each logical statement
#########################################################################

${INIT_CMD} >> $LOG 2>&1 <<!!!
drop view ChangeView${SEMI_STRING}
${COMMIT_STRING}
create view ChangeView
   (pathId, trackId, fileId, versionId, levelId, type,
   defectPrefix, defectName, defectReference, defectAbstract, defectType,
   releaseName, pathName, versionSID, userId, levelName, newPathName,
   userName,  fileType, fmode, changeDate) as
select
   c.pathId, c.trackId, c.fileId, c.versionId, c.levelId, c.type,
   d.prefix, d.name, d.reference, d.abstract, d.type,
   n.name, p.name, v.SID, c.userId, b.name, h.name, u.login, f.type,
   f.fmode, v.changeDate
from
   Changes c, Tracks t, Defects d, Releases n, Path p, Path h, Versions v,
   Levels b, Files f, Users u
where
   c.trackId   = t.id     and
   t.defectId  = d.id     and
   t.releaseId = n.id     and
   c.versionId = v.id     and
   c.pathId    = p.id     and
   c.levelId   = b.id     and
   f.id        = c.fileId and
   u.id        = c.userId and
   p.id        = f.pathId and
   h.id        = f.nuPathId
${SEMI_STRING}
${COMMIT_STRING}
commit${SEMI_STRING}
${COMMIT_STRING}
select * from ChangeView where 1=0 ${SEMI_STRING}
${COMMIT_STRING}
!!!
# The above !!! indicates the end of the long series of database commands


if [ ${DATABASE} = "DB2" -o ${DATABASE} = "db2" ]
  then
    ${SQL} connect reset >> $LOG 2>&1
    ${SQL} terminate >> $LOG 2>&1
fi

print " "
print "CmvcUpdateChangeView: Please see the following log for the details"
print "          of the execution of the $DATABASE commands: " $LOG
print " "
print "CmvcUpdateChangeView: End of script"

exit 0

# end of file
