/*------------------------------------------------------*/
/* PROGRAM NAME:  fhbcpp.c                              */
/* Purpose:   IBM TeamConnection Sample Cobol parser                    */
/* INPUT Parameters:      Input-file Output-file
/* Description: This program is designed to parse lines of text in ASCII         */
/*                   files specified as an argument when the program is          */
/*                   invoked. The program takes any file scheme valid    */
/*                   file name and file extension.                          */
/*           In each line of the input file the program looks for the patterns  */
/*               #include <filename.ext>                */
/*               #include "filename.ext" pattern.       */
/*           If found, the string is parsed and the file name with the */
/*           file extension is extracted.        */
/*                   If output filename is specified then it is used, otherwise, */
/*                   the output is stored in FILE.OUT                            */
/*                   This process continues until all the logged files are read. */
/* Notes:   Basic Parsing Function.                                      */
/*                  Limited Error checking.                                      */
/*                  Avoids recursive include files.                              */
/* Compilation notes:  */
/*          Microsoft Windows C++:   cl fhbcpp.c func.c -D__NT__      */
/*          Unix:   cc fhbcpp.c func.c -o fhbcpp      */
/*********************************************************************************/

#ifdef __NT__
#include <io.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fhbcpp.h"


/**************************************/
/* Global variables                   */
/**************************************/
char Infilename[80], Outfilename[80];
FILE *Infile, *Outfile;
/**************************************/


/* Retrieves parameter */
void getparam(int argc, char **argv, char *infilename, char *outfilename)
{
   /* Get parameter */
   if (argc-1 == 0)
   {
      printf("\nInvalid number of parameters\n");
      printf("Syntax: fhbcpp  <input file>  [output file]\n\n");
      exit(1);
   }
   else
   {
      strcpy(infilename, argv[1]);
      if (argc-1 >= 2)
         strcpy(outfilename, argv[2]);
      else
         strcpy(outfilename, OUTFILE);
   }
}

/* Opens input and output files */
FILE *openfile(char *filename, char *mode)
{
   FILE *file;

   if (!(file = fopen(filename, mode)))
   {
      printf("\nError opening %s file\n", mode[0]=='r' ? "PLI source input" : "output");
      exit(1);
   }
   else
      return file;
}



/**************************************/
/* Main Program                       */
/**************************************/
int main(int argc, char **argv)
{
   /* Get parameter */
   getparam(argc, argv, Infilename, Outfilename);

   /* Open files */
   if ((Infile = openfile(Infilename, "r")))
      Outfile = openfile(Outfilename, "w");

   /* Follow structure of Cobol code */
   do_mri();

   /* Close files */
   fclose(Infile);
   fclose(Outfile);

   return 0;
}

/* end of file */
