/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.reuse.awt.ButtonPanel;
import com.ibm.vatc.reuse.awt.Notebook;
import com.ibm.vatc.tcmerge.ConvertColors;
import com.ibm.vatc.tcmerge.EditorPage;
import com.ibm.vatc.tcmerge.FileLocatorPage;
import com.ibm.vatc.tcmerge.IOProperties;
import com.ibm.vatc.tcmerge.LayoutPage;
import com.ibm.vatc.tcmerge.MergeGui;
import com.ibm.vatc.tcmerge.Options;
import com.ibm.vatc.tcmerge.PropertiesPage;
import com.ibm.vatc.tcmerge.TCMergeException;
import com.ibm.vatc.tcmerge.TCMergeHelp;
import com.ibm.vatc.tcmerge.TabString;
import com.ibm.vatc.tcmerge.ViewParam;
import com.ibm.vatc.tcmerge.WarningDialog;
import com.ibm.vatc.tcmerge.YesNoDialog;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;

public class PropertiesGui
extends Dialog {
    GridBagLayout gbl;
    GridBagConstraints gbc;
    Notebook ntbk;
    int tabAlign;
    int ntbkStyle;
    MergeGui mg;
    IOProperties propertyFile;
    Options options;
    String action;
    EditorPage editorPage;
    LayoutPage layoutPage;
    FileLocatorPage fileLocationPage;
    ConvertColors cc;
    ViewParam viewParam;
    KeyboardListener keyListener;

    PropertiesGui(MergeGui mergeGui) {
        super(mergeGui, tcmerge.locResource.getString("TITLE_PROPERTIES"), true);
        this.mg = mergeGui;
        this.propertyFile = this.mg.getPropertiesFile();
        this.options = this.mg.getOptions();
        this.cc = new ConvertColors();
        this.viewParam = this.mg.getViewParam();
        ((Component)this).setFont(tcmerge.getDefaultFont());
        this.setNotebookStyle();
        this.addComponents();
        this.setupNotebook();
        DialogListener dialogListener = new DialogListener();
        this.addWindowListener(dialogListener);
        this.keyListener = new KeyboardListener();
        this.addKeyListener(this.keyListener);
        this.pack();
        ((Component)this).setSize(this.calculateSize());
        Dimension dimension = this.mg.getSize();
        Dimension dimension2 = this.getSize();
        Point point = this.mg.getLocationOnScreen();
        ((Component)this).setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
        this.show();
    }

    Dimension calculateSize() {
        int n;
        int n2;
        int n3 = 90;
        int n4 = 24;
        int n5 = 24;
        Dimension dimension = new Dimension();
        if (tcmerge.getDefaultFont().getName() == "Monospaced") {
            n5 = 48;
        }
        if ((n2 = n4 * this.getToolkit().getFontMetrics(tcmerge.getDefaultFont()).getHeight() + n3) < 460) {
            n2 = 460;
        }
        if ((n = n5 * this.getToolkit().getFontMetrics(tcmerge.getDefaultFont()).charWidth('W') + n3) < 430) {
            n = 430;
        }
        dimension.setSize(n, n2);
        return dimension;
    }

    void setNotebookStyle() {
        this.tabAlign = 0;
        this.ntbkStyle = 0;
    }

    void addComponents() {
        ((Component)this).setBackground(Color.lightGray);
        String[][] stringArray = new String[][]{{tcmerge.locResource.getString("STR_OK"), "OK"}, {tcmerge.locResource.getString("STR_CANCEL"), "Cancel"}, {tcmerge.locResource.getString("STR_APPLY"), "Apply"}, {tcmerge.locResource.getString("STR_HELP"), "Help"}};
        ButtonPanel buttonPanel = new ButtonPanel(stringArray, new BListener());
        buttonPanel.addKeyListener(this.keyListener);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.setLayout(this.gbl);
        this.gbc.fill = 1;
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.gbc.gridwidth = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.ntbk = new Notebook(this.tabAlign, this.ntbkStyle);
        this.gbl.setConstraints(this.ntbk, this.gbc);
        this.add(this.ntbk);
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridwidth = -1;
        this.gbl.setConstraints(buttonPanel, this.gbc);
        this.add(buttonPanel);
        this.gbc.gridwidth = 0;
        Label label = new Label(" ");
        this.gbl.setConstraints(label, this.gbc);
        this.add(label);
    }

    void setupNotebook() {
        this.editorPage = new EditorPage(this.mg, this);
        TabString tabString = new TabString(tcmerge.locResource.getString("STR_EDITOR"), this.editorPage);
        this.ntbk.addPage(tabString, this.editorPage, null);
        this.layoutPage = new LayoutPage(this.mg, this);
        tabString = new TabString(tcmerge.locResource.getString("STR_LAYOUT"), this.layoutPage);
        this.ntbk.addPage(tabString, this.layoutPage, null);
        this.fileLocationPage = new FileLocatorPage(this.mg, this);
        tabString = new TabString(tcmerge.locResource.getString("STR_FILELOCATOR"), this.fileLocationPage);
        this.ntbk.addPage(tabString, this.fileLocationPage, null);
        tabString = (TabString)this.ntbk.getTab();
        PropertiesPage propertiesPage = tabString.getPage();
        propertiesPage.resetPage();
    }

    public String getAction() {
        return this.action;
    }

    private void SetAllProperties() {
        this.options.getEditor().setFontName(this.editorPage.fontName);
        this.options.getEditor().setFontSize(this.editorPage.fontSize);
        int n = -1;
        try {
            n = Integer.parseInt(this.editorPage.tabField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            new WarningDialog((Frame)this.mg, tcmerge.locResource.getString("STR_PROPERTIES_ERROR1"));
        }
        if (n < 0 || n > 80) {
            WarningDialog warningDialog = new WarningDialog((Frame)this.mg, tcmerge.locResource.getString("STR_PROPERTIES_ERROR1"));
            warningDialog.show();
        } else {
            this.options.getEditor().setTab(n);
        }
        this.options.getEditor().setZerothCurrentDiffFG(this.editorPage.foreInput1);
        this.options.getEditor().setZerothDiffcolor(this.editorPage.backInput1);
        this.options.getEditor().setFirstCurrentDiffFG(this.editorPage.foreInput2);
        this.options.getEditor().setFirstDiffColor(this.editorPage.backInput2);
        this.options.getEditor().setSecondCurrentDiffFG(this.editorPage.foreInput3);
        this.options.getEditor().setSecondDiffColor(this.editorPage.backInput3);
        this.options.getEditor().setMatchedForeground(this.editorPage.foreCommon);
        this.options.getEditor().setMatchedBackground(this.editorPage.backCommon);
        this.options.getEditor().setOutviewEditedFG(this.editorPage.foreEdit);
        this.options.getEditor().setOutviewEditedColor(this.editorPage.backEdit);
        this.options.getEditor().setNavigatorDifferenceBlock(this.editorPage.navDiffBlock);
        this.options.getEditor().setNavigatorCommonBlock(this.editorPage.navCommonBlock);
        this.viewParam.setNavigator(LayoutPage.navigatorUp);
        this.viewParam.setLegend(LayoutPage.legendUp);
        this.options.getLocation().setPrimeLocation(this.fileLocationPage.dir1TextField.getText());
        this.options.getLocation().setFirstLocation(this.fileLocationPage.dir2TextField.getText());
        this.options.getLocation().setSecondLocation(this.fileLocationPage.dir3TextField.getText());
        this.options.getLocation().setOutputLocation(this.fileLocationPage.outputTextField.getText());
    }

    public boolean SetLayoutLocationProperties() {
        boolean bl = true;
        if (LayoutPage.navigatorUp) {
            ((Hashtable)this.propertyFile.propSettings).put("navigatorupordown", "true");
        } else {
            ((Hashtable)this.propertyFile.propSettings).put("navigatorupordown", "false");
        }
        if (LayoutPage.legendUp) {
            ((Hashtable)this.propertyFile.propSettings).put("legendupordown", "true");
        } else {
            ((Hashtable)this.propertyFile.propSettings).put("legendupordown", "false");
        }
        try {
            String string = this.fileLocationPage.dir1TextField.getText();
            File file = new File(string);
            if (string.equals("")) {
                ((Hashtable)this.propertyFile.propSettings).put("primelocation", string);
            } else {
                if (file.isFile()) {
                    throw new TCMergeException(30, string);
                }
                if (!file.canRead()) {
                    throw new TCMergeException(1, string);
                }
                ((Hashtable)this.propertyFile.propSettings).put("primelocation", string);
            }
            string = this.fileLocationPage.dir2TextField.getText();
            file = new File(string);
            if (string.equals("")) {
                ((Hashtable)this.propertyFile.propSettings).put("firstprimelocation", string);
            } else {
                if (file.isFile()) {
                    throw new TCMergeException(30, string);
                }
                if (!file.canRead()) {
                    throw new TCMergeException(1, string);
                }
                ((Hashtable)this.propertyFile.propSettings).put("firstprimelocation", string);
            }
            string = this.fileLocationPage.dir3TextField.getText();
            file = new File(string);
            if (string.equals("")) {
                ((Hashtable)this.propertyFile.propSettings).put("secondprimelocation", string);
            } else {
                if (file.isFile()) {
                    throw new TCMergeException(30, string);
                }
                if (!file.canRead()) {
                    throw new TCMergeException(1, string);
                }
                ((Hashtable)this.propertyFile.propSettings).put("secondprimelocation", string);
            }
            string = this.fileLocationPage.outputTextField.getText();
            file = new File(string);
            if (string.equals("")) {
                ((Hashtable)this.propertyFile.propSettings).put("outputprimelocation", string);
            } else {
                if (file.isFile()) {
                    throw new TCMergeException(30, string);
                }
                if (!file.canRead()) {
                    throw new TCMergeException(1, string);
                }
                ((Hashtable)this.propertyFile.propSettings).put("outputprimelocation", string);
            }
        }
        catch (TCMergeException tCMergeException) {
            WarningDialog warningDialog = new WarningDialog((Frame)this.mg, tCMergeException.toString());
            warningDialog.show();
            warningDialog.dispose();
            bl = false;
        }
        return bl;
    }

    class BListener
    implements ActionListener {
        BListener() {
            PropertiesGui.this = PropertiesGui.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesGui.this.action = actionEvent.getActionCommand();
            if (PropertiesGui.this.action.equals("OK")) {
                ((Hashtable)PropertiesGui.this.propertyFile.propSettings).put("lastusedschemename", PropertiesGui.this.editorPage.schemeChoice.getSelectedItem());
                PropertiesGui.this.SetAllProperties();
                if (PropertiesGui.this.SetLayoutLocationProperties()) {
                    PropertiesGui.this.propertyFile.SavePropertyFile();
                    PropertiesGui.this.mg.setFontsInViews();
                    PropertiesGui.this.mg.repaintWindows();
                    ((Component)PropertiesGui.this).setVisible(false);
                    return;
                }
            } else {
                if (PropertiesGui.this.action.equals("Cancel")) {
                    ((Hashtable)PropertiesGui.this.propertyFile.propSettings).put("lastusedschemename", PropertiesGui.this.editorPage.schemeChoice.getSelectedItem());
                    if (PropertiesGui.this.editorPage.needToSave) {
                        String string = tcmerge.locResource.getString("STR_SAVESCHEMES");
                        String string2 = tcmerge.locResource.getString("STR_TCMERGE");
                        YesNoDialog yesNoDialog = new YesNoDialog((Frame)PropertiesGui.this.mg, string, string2);
                        yesNoDialog.show();
                        if (!yesNoDialog.getAction().equals("Yes")) {
                            yesNoDialog.dispose();
                            yesNoDialog = null;
                        } else if (yesNoDialog != null) {
                            PropertiesGui.this.propertyFile.SavePropertyFile();
                        }
                    }
                    PropertiesGui.this.dispose();
                    return;
                }
                if (PropertiesGui.this.action.equals("Apply")) {
                    PropertiesGui.this.SetAllProperties();
                    PropertiesGui.this.SetLayoutLocationProperties();
                    PropertiesGui.this.mg.setFontsInViews();
                    PropertiesGui.this.mg.repaintWindows();
                    return;
                }
                if (PropertiesGui.this.action.equals("Help")) {
                    TCMergeHelp.showHelp(PropertiesGui.this.mg, "HDRFILE100");
                }
            }
        }
    }

    class DialogListener
    extends WindowAdapter {
        int aixkluge;

        public void windowClosing(WindowEvent windowEvent) {
            PropertiesGui.this.action = "CANCEL";
            ((Component)PropertiesGui.this).setVisible(false);
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (this.aixkluge == 0) {
                PropertiesGui.this.editorPage.requestFocus();
            }
            this.aixkluge = 1;
        }

        DialogListener() {
            PropertiesGui.this = PropertiesGui.this;
        }
    }

    class KeyboardListener
    extends KeyAdapter {
        KeyboardListener() {
            PropertiesGui.this = PropertiesGui.this;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                PropertiesGui.this.action = "CANCEL";
                ((Component)PropertiesGui.this).setVisible(false);
            }
        }
    }
}

