/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.DiffInfoCommon;
import com.ibm.vatc.tcmerge.MakeViews;
import com.ibm.vatc.tcmerge.MergeGui;
import com.ibm.vatc.tcmerge.MergeGuiKeyListener;
import com.ibm.vatc.tcmerge.Options;
import com.ibm.vatc.tcmerge.ScrollPanel;
import com.ibm.vatc.tcmerge.Status;
import com.ibm.vatc.tcmerge.TextComposite;
import com.ibm.vatc.tcmerge.TextRefOutput;
import com.ibm.vatc.tcmerge.ViewParam;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Scrollbar;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

class OutputView
extends Canvas
implements MouseListener {
    ScrollPanel scrollPanel;
    Scrollbar hAdj;
    Scrollbar vAdj;
    MergeGui mergeGui;
    MakeViews makeViews;
    ViewParam viewParam;
    Options options;
    Status status;
    Vector tableOutput;
    Vector tableComposite;
    Vector tableEdit;
    Dimension size;
    int firstLineInView;
    private int initialLocX;
    private int initialLocY;
    Font normalFont;
    private int maxWidth;
    private int maxAdvance;
    private int charHeight;
    private int ascent;
    static final short STRING_BUFF_SIZE = 512;
    MergeGuiKeyListener mergeGuiKeyListener;

    OutputView(ScrollPanel scrollPanel, MergeGui mergeGui) {
        this.mergeGui = mergeGui;
        this.scrollPanel = scrollPanel;
        this.makeViews = mergeGui.getMakeViews();
        this.viewParam = mergeGui.getViewParam();
        this.options = mergeGui.getOptions();
        this.status = mergeGui.getStatus();
        this.tableOutput = this.makeViews.getTableOutput();
        this.tableComposite = this.makeViews.getTableComposite();
        this.tableEdit = this.makeViews.getTableEdit();
        this.hAdj = this.scrollPanel.getHAdjustable();
        this.vAdj = this.scrollPanel.getVAdjustable();
        this.size = new Dimension();
        this.size.width = 100;
        this.size.height = 100;
        this.setFont();
        this.vAdj.setMaximum((this.tableOutput.size() + 1) * this.charHeight);
        this.addMouseListener(this);
        this.setVScrollToCurrentDiff();
        this.scrollPanel.setPaintArea(this);
        this.mergeGuiKeyListener = new MergeGuiKeyListener(this.mergeGui);
        this.addKeyListener(this.mergeGuiKeyListener);
    }

    public void setFont() {
        String string = this.options.getEditor().getFontName();
        int n = this.options.getEditor().getFontSize();
        this.normalFont = new Font(string, 0, n);
        this.setFont(this.normalFont);
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.normalFont);
        this.charHeight = fontMetrics.getHeight();
        this.maxAdvance = fontMetrics.getMaxAdvance();
        this.initialLocX = 0;
        this.initialLocY = fontMetrics.getAscent();
        this.ascent = fontMetrics.getAscent();
    }

    public synchronized void paint(Graphics graphics) {
        this.requestFocus();
        this.hAdj.setUnitIncrement(this.maxAdvance);
        this.hAdj.setBlockIncrement(this.getSize().width);
        this.vAdj.setUnitIncrement(this.charHeight);
        this.vAdj.setBlockIncrement(this.getSize().height);
        int n = this.hAdj.getValue();
        int n2 = this.vAdj.getValue();
        this.firstLineInView = Math.round(n2 / this.charHeight);
        this.initialLocX = -n;
        int n3 = Math.min(this.getSize().height, this.tableOutput.size() * this.charHeight) / this.charHeight;
        while (this.firstLineInView + n3 > this.tableOutput.size()) {
            --this.firstLineInView;
        }
        this.vAdj.setValue(this.firstLineInView * this.charHeight);
        this.maxWidth = Math.max(this.getSize().width, this.hAdj.getMaximum());
        int n4 = 0;
        while (n4 < n3) {
            this.drawString(graphics, this.firstLineInView, n4);
            ++n4;
        }
        graphics.setColor(this.options.getEditor().getMatchedBackground());
        graphics.fillRect(this.initialLocX, this.initialLocY + n3 * this.charHeight - this.ascent, this.maxWidth, this.getSize().height - n3 * this.charHeight);
        this.scrollPanel.doLayout();
        this.validate();
        this.hAdj.setValues(this.hAdj.getValue(), this.scrollPanel.getHVisibleAmount(), 0, 1000);
        this.vAdj.setValues(this.vAdj.getValue(), this.scrollPanel.getVVisibleAmount(), 0, this.tableOutput.size() * this.charHeight + this.charHeight);
    }

    public void drawString(Graphics graphics, int n, int n2) {
        TextRefOutput textRefOutput = (TextRefOutput)this.tableOutput.elementAt(n + n2);
        byte by = textRefOutput.flag;
        int n3 = textRefOutput.textRef;
        if ((by & 1) != 0) {
            String string;
            if ((by & 2) != 0) {
                String string2;
                if (n3 == -1) {
                    graphics.setColor(this.options.getEditor().getOutviewCurrentDiffBG());
                    graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight + 1);
                    String string3 = this.addLineNumber("", n + n2);
                    graphics.setColor(this.options.getEditor().getOutviewMatchedFG());
                    graphics.drawString(string3, this.initialLocX, this.initialLocY + n2 * this.charHeight);
                    return;
                }
                if ((by & 0x10) != 0) {
                    graphics.setColor(this.options.getEditor().getZerothDiffColor());
                    graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight + 1);
                    graphics.setColor(this.options.getEditor().getZerothCurrentDiffFG());
                } else if ((by & 0x20) != 0) {
                    graphics.setColor(this.options.getEditor().getFirstDiffColor());
                    graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight + 1);
                    graphics.setColor(this.options.getEditor().getFirstCurrentDiffFG());
                } else if ((by & 0x40) != 0) {
                    graphics.setColor(this.options.getEditor().getSecondDiffColor());
                    graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight + 1);
                    graphics.setColor(this.options.getEditor().getSecondCurrentDiffFG());
                } else {
                    graphics.setColor(this.options.getEditor().getOutviewEditedColor());
                    graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight + 1);
                    graphics.setColor(this.options.getEditor().getOutviewEditedFG());
                }
                if (n3 == -2) {
                    String string4 = this.addLineNumber(tcmerge.locResource.getString("STR_LINE_WILL_NOT_BE_SAVED"), n + n2);
                    graphics.drawString(string4, this.initialLocX, this.initialLocY + n2 * this.charHeight);
                    return;
                }
                if (n3 == -3) {
                    String string5 = this.addLineNumber("", n + n2);
                    graphics.drawString(string5, this.initialLocX, this.initialLocY + n2 * this.charHeight);
                    return;
                }
                if ((by & 8) != 0) {
                    string2 = (String)this.tableEdit.elementAt(n3);
                } else {
                    TextComposite textComposite = (TextComposite)this.tableComposite.elementAt(n3);
                    string2 = textComposite.text;
                }
                string2 = this.formatString(string2);
                string2 = this.addLineNumber(string2, n + n2);
                graphics.drawString(string2, this.initialLocX, this.initialLocY + n2 * this.charHeight);
                return;
            }
            if (n3 == -1) {
                graphics.setColor(this.options.getEditor().getOutviewEmptyDiffBG());
                graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight + 1);
                graphics.setColor(this.options.getEditor().getOutviewMatchedFG());
                String string6 = this.addLineNumber("", n + n2);
                graphics.drawString(string6, this.initialLocX, this.initialLocY + n2 * this.charHeight);
                return;
            }
            graphics.setColor(this.options.getEditor().getOutviewNonemptyDiffBG());
            graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight + 1);
            if ((by & 0x10) != 0) {
                graphics.setColor(this.options.getEditor().getZerothDiffColor());
            } else if ((by & 0x20) != 0) {
                graphics.setColor(this.options.getEditor().getFirstDiffColor());
            } else if ((by & 0x40) != 0) {
                graphics.setColor(this.options.getEditor().getSecondDiffColor());
            } else {
                graphics.setColor(this.options.getEditor().getOutviewEditedColor());
            }
            if (n3 == -2) {
                String string7 = this.addLineNumber(tcmerge.locResource.getString("STR_LINE_WILL_NOT_BE_SAVED"), n + n2);
                graphics.drawString(string7, this.initialLocX, this.initialLocY + n2 * this.charHeight);
                return;
            }
            if (n3 == -3) {
                String string8 = this.addLineNumber("", n + n2);
                graphics.drawString(string8, this.initialLocX, this.initialLocY + n2 * this.charHeight);
                return;
            }
            if ((by & 8) != 0) {
                string = (String)this.tableEdit.elementAt(n3);
            } else {
                TextComposite textComposite = (TextComposite)this.tableComposite.elementAt(n3);
                string = textComposite.text;
            }
            string = this.formatString(string);
            string = this.addLineNumber(string, n + n2);
            graphics.drawString(string, this.initialLocX, this.initialLocY + n2 * this.charHeight);
            return;
        }
        graphics.setColor(this.options.getEditor().getOutviewMatchedBG());
        graphics.fillRect(this.initialLocX, this.initialLocY + n2 * this.charHeight - this.ascent, this.maxWidth, this.charHeight + 1);
        graphics.setColor(this.options.getEditor().getOutviewMatchedFG());
        TextComposite textComposite = (TextComposite)this.tableComposite.elementAt(n3);
        String string = textComposite.text;
        string = this.formatString(string);
        string = this.addLineNumber(string, n + n2);
        graphics.drawString(string, this.initialLocX, this.initialLocY + n2 * this.charHeight);
    }

    private String formatString(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(512);
        if (string.equals("^~:ZeroLength:~^")) {
            string2 = "";
        } else if (string.length() == 0) {
            string2 = "";
        } else {
            int n;
            int n2 = this.options.getEditor().getTab();
            stringBuffer.insert(0, string);
            while ((n = (string2 = stringBuffer.toString()).indexOf(9, 0)) != -1) {
                int n3 = n % n2;
                int n4 = 0;
                while (n4 < n2 - n3) {
                    if (n4 == 0) {
                        stringBuffer.setCharAt(n + n4, ' ');
                    } else {
                        stringBuffer.insert(n + n4, ' ');
                    }
                    ++n4;
                }
            }
            string2 = stringBuffer.toString();
            stringBuffer = null;
        }
        return string2;
    }

    private String addLineNumber(String string, int n) {
        if (this.viewParam.getIsLineShown()) {
            Integer n2 = new Integer(n + 1);
            String string2 = n2.toString();
            int n3 = string2.length();
            int n4 = 0;
            while (n4 < 8 - n3) {
                string2 = String.valueOf(string2) + " ";
                ++n4;
            }
            String string3 = String.valueOf(string2) + string;
            n2 = null;
            return string3;
        }
        return string;
    }

    public void setVerticalScrollbar(int n) {
        if (n * this.charHeight > this.vAdj.getMaximum()) {
            this.vAdj.setValue(this.vAdj.getMaximum());
            return;
        }
        this.vAdj.setValue(n * this.charHeight);
    }

    public void setVScrollToCurrentDiff() {
        int n = this.viewParam.getCurrentDiff();
        if (this.makeViews.getDiffTableOutput().size() != 0) {
            DiffInfoCommon diffInfoCommon = (DiffInfoCommon)this.makeViews.getDiffTableOutput().elementAt(n);
            int n2 = diffInfoCommon.getStartBlock();
            this.setVerticalScrollbar(n2);
        }
    }

    public void addNotify() {
        super.addNotify();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.status.setMessageFlag(false);
            this.status.repaint();
            this.setCursor(this.mergeGui.waitCursor);
            if (mouseEvent.getClickCount() == 2) {
                int n = -1;
                int n2 = -1;
                int n3 = -1;
                int n4 = mouseEvent.getY();
                int n5 = (int)((float)(n4 += this.vAdj.getValue()) / (float)this.charHeight);
                Vector vector = this.makeViews.getDiffTableOutput();
                int n6 = 0;
                while (n6 < vector.size()) {
                    DiffInfoCommon diffInfoCommon = (DiffInfoCommon)vector.elementAt(n6);
                    n = diffInfoCommon.getStartBlock();
                    n2 = diffInfoCommon.getEndBlock();
                    if (n <= n5 && n5 <= n2) {
                        n3 = n6;
                        break;
                    }
                    ++n6;
                }
                if (n3 != -1 && n3 == this.viewParam.getCurrentDiff()) {
                    this.mergeGui.editBlock(n5);
                }
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public Dimension getMinimumSize() {
        return this.size;
    }
}

