/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.reuse.awt.ButtonPanel;
import com.ibm.vatc.reuse.awt.EButton;
import com.ibm.vatc.reuse.awt.GridTools;
import com.ibm.vatc.reuse.awt.Notebook;
import com.ibm.vatc.tcmerge.DiffInput;
import com.ibm.vatc.tcmerge.SingleLineCanvas;
import com.ibm.vatc.tcmerge.StringTools;
import com.ibm.vatc.tcmerge.TCMergeException;
import com.ibm.vatc.tcmerge.TCMergeHelp;
import com.ibm.vatc.tcmerge.Validate;
import com.ibm.vatc.tcmerge.WarningDialog;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class MergeOptionsDialog
extends Dialog {
    Frame parentFrame;
    int numFiles;
    Notebook ntbk;
    Panel contentPage;
    Panel filePage;
    Panel titlesPage;
    TextField ignoreColumnsTextField;
    TextField[] titlesTextField;
    Choice ignoreBlanksChoice;
    Choice ignoreUniqueDifferencesChoice;
    Choice primeOutputFileChoice;
    Checkbox ignoreCaseSensitiveCheckbox;
    Checkbox automergeCheckbox;
    Checkbox ignoreBlankLinesCheckbox;
    List rangesToIgnoreList;
    String action;
    EButton addButton;
    EButton removeButton;
    String ignoreBlanksAnswer;
    int ignoreUniqueDifferencesAnswer;
    int ignoreUniqueDifferencesOriginal;
    int primeOutputFileAnswer;
    int primeOutputFileOriginal;
    boolean automergeAnswer;
    boolean ignoreCaseSensitiveBoolean;
    String ignoreCaseSensitiveAnswer;
    Vector columnsToIgnoreAnswer;
    Vector titlesAnswer;
    boolean ignoreBlankLinesAnswer;
    boolean recalculate;
    boolean modalOn;

    public MergeOptionsDialog(Frame frame, int n) {
        super(frame, tcmerge.locResource.getString("TITLE_MERGE_OPTIONS"), true);
        this.parentFrame = frame;
        this.numFiles = n;
        ((Component)this).setSize(this.calculateSize());
        ((Component)this).setFont(tcmerge.getDefaultFont());
        this.ignoreUniqueDifferencesAnswer = -1;
        this.primeOutputFileAnswer = -1;
        this.columnsToIgnoreAnswer = new Vector();
        this.ignoreBlanksAnswer = "";
        this.ignoreCaseSensitiveAnswer = "";
        this.titlesAnswer = new Vector(3);
        this.titlesAnswer.addElement("");
        this.titlesAnswer.addElement("");
        this.titlesAnswer.addElement("");
        this.modalOn = false;
    }

    Dimension calculateSize() {
        int n;
        int n2;
        int n3 = 120;
        int n4 = 24;
        int n5 = 24;
        Dimension dimension = new Dimension();
        if (tcmerge.getDefaultFont().getName() == "Monospaced") {
            n5 = 48;
            n3 = 180;
        }
        if ((n2 = n4 * this.getToolkit().getFontMetrics(tcmerge.getDefaultFont()).getHeight()) < 330) {
            n2 = 330;
        }
        if ((n = n5 * this.getToolkit().getFontMetrics(tcmerge.getDefaultFont()).charWidth('W') + n3) < 450) {
            n = 450;
        }
        dimension.setSize(n, n2);
        return dimension;
    }

    public void createDialog() {
        DialogListener dialogListener = new DialogListener();
        this.addWindowListener(dialogListener);
        KeyboardListener keyboardListener = new KeyboardListener();
        this.addKeyListener(keyboardListener);
        String[][] stringArray = new String[][]{{tcmerge.locResource.getString("STR_OK"), "OK"}, {tcmerge.locResource.getString("STR_CANCEL"), "Cancel"}, {tcmerge.locResource.getString("STR_HELP"), "Help"}};
        this.contentPage = new Panel();
        this.contentPage.setLayout(new GridBagLayout());
        GridTools.constrain(this.contentPage, new Label(tcmerge.locResource.getString("STR_TEXT")), 2, 1, 1, 1, 0, 0, 17, 0);
        GridTools.constrain(this.contentPage, new SingleLineCanvas(360), 2, 1, 5, 1);
        GridTools.constrain(this.contentPage, new Label(tcmerge.locResource.getString("STR_IGNORE_COLUMNS")), 2, 2, 1, 1, 0, 0, 17, 0);
        this.ignoreColumnsTextField = new TextField("", 6);
        this.ignoreColumnsTextField.addKeyListener(keyboardListener);
        this.ignoreColumnsTextField.setFont(tcmerge.getDefaultFont());
        this.ignoreColumnsTextField.addKeyListener(new TextFieldKeyListener("Add"));
        GridTools.constrain(this.contentPage, this.ignoreColumnsTextField, 2, 3, 1, 1, 0, 0, 17, 2);
        GridTools.constrain(this.contentPage, new Label(tcmerge.locResource.getString("STR_RANGE_TEMPLATE")), 2, 4, 1, 1, 0, 0, 17, 0);
        this.ignoreCaseSensitiveCheckbox = new Checkbox(tcmerge.locResource.getString("STR_IGNORE_CASE"), this.ignoreCaseSensitiveBoolean);
        this.ignoreCaseSensitiveCheckbox.addKeyListener(keyboardListener);
        GridTools.constrain(this.contentPage, this.ignoreCaseSensitiveCheckbox, 2, 5, 1, 1, 0, 0, 17, 0);
        this.addButton = new EButton(tcmerge.locResource.getString("STR_ADD_BUTTON"));
        this.addButton.setActionCommand("Add");
        this.addButton.setSize(60, 24);
        this.addButton.addActionListener(new ButtonListener());
        this.addButton.addKeyListener(keyboardListener);
        GridTools.constrain(this.contentPage, this.addButton, 4, 3, 1, 1, 0, 0, 10, 2);
        this.addButton.setEnabled(false);
        this.removeButton = new EButton(tcmerge.locResource.getString("STR_REMOVE_BUTTON"));
        this.removeButton.setActionCommand("Remove");
        this.removeButton.setSize(60, 24);
        this.removeButton.addActionListener(new ButtonListener());
        this.removeButton.addKeyListener(keyboardListener);
        GridTools.constrain(this.contentPage, this.removeButton, 4, 4, 1, 1, 0, 0, 10, 2);
        GridTools.constrain(this.contentPage, new Label(tcmerge.locResource.getString("STR_RANGES_TO_IGNORE")), 6, 2, 1, 1, 0, 0, 17, 0);
        this.rangesToIgnoreList = new List(4, true);
        int n = 0;
        while (n < this.columnsToIgnoreAnswer.size()) {
            this.rangesToIgnoreList.add((String)this.columnsToIgnoreAnswer.elementAt(n));
            ++n;
        }
        this.rangesToIgnoreList.addKeyListener(keyboardListener);
        this.rangesToIgnoreList.addItemListener(new ListListener());
        GridTools.constrain(this.contentPage, this.rangesToIgnoreList, 6, 3, 1, 3, 0, 0, 17, 0);
        if (this.rangesToIgnoreList.getItemCount() == 0) {
            this.removeButton.setEnabled(false);
        }
        GridTools.constrain(this.contentPage, new Label(tcmerge.locResource.getString("STR_BLANKS")), 2, 7, 1, 1, 0, 0, 17, 0);
        GridTools.constrain(this.contentPage, new SingleLineCanvas(360), 2, 7, 5, 1);
        GridTools.constrain(this.contentPage, new Label(tcmerge.locResource.getString("STR_IGNORE_BLANKS_WITHIN_LINES")), 2, 8, 1, 1, 0, 0, 17, 0);
        this.ignoreBlanksChoice = new Choice();
        this.ignoreBlanksChoice.add(tcmerge.locResource.getString("STR_BRACKETED_NONE"));
        this.ignoreBlanksChoice.add(tcmerge.locResource.getString("STR_IGNORE_BLANKS_LEADING"));
        this.ignoreBlanksChoice.add(tcmerge.locResource.getString("STR_IGNORE_BLANKS_TRAILING"));
        this.ignoreBlanksChoice.add(tcmerge.locResource.getString("STR_IGNORE_BLANKS_BOTH"));
        this.ignoreBlanksChoice.add(tcmerge.locResource.getString("STR_IGNORE_BLANKS_ALL"));
        if (this.ignoreBlanksAnswer.equals("-l")) {
            this.ignoreBlanksChoice.select(tcmerge.locResource.getString("STR_IGNORE_BLANKS_LEADING"));
        } else if (this.ignoreBlanksAnswer.equals("-t")) {
            this.ignoreBlanksChoice.select(tcmerge.locResource.getString("STR_IGNORE_BLANKS_TRAILING"));
        } else if (this.ignoreBlanksAnswer.equals("-l -t")) {
            this.ignoreBlanksChoice.select(tcmerge.locResource.getString("STR_IGNORE_BLANKS_BOTH"));
        } else if (this.ignoreBlanksAnswer.equals("-w")) {
            this.ignoreBlanksChoice.select(tcmerge.locResource.getString("STR_IGNORE_BLANKS_ALL"));
        }
        this.ignoreBlanksChoice.addKeyListener(keyboardListener);
        GridTools.constrain(this.contentPage, this.ignoreBlanksChoice, 2, 9, 1, 1, 0, 0, 17, 2);
        this.ignoreBlankLinesCheckbox = new Checkbox(tcmerge.locResource.getString("STR_IGNORE_BLANK_LINES"), this.ignoreBlankLinesAnswer);
        this.ignoreBlankLinesCheckbox.addKeyListener(keyboardListener);
        GridTools.constrain(this.contentPage, this.ignoreBlankLinesCheckbox, 6, 8, 1, 1);
        ButtonPanel buttonPanel = new ButtonPanel(stringArray, new ButtonListener());
        buttonPanel.addKeyListener(keyboardListener);
        GridTools.constrain(this.contentPage, buttonPanel, 4, 10, 3, 1, 0, 0, 13, 0);
        Canvas canvas = new Canvas();
        canvas.setSize(10, 10);
        GridTools.constrain(this.contentPage, canvas, 1, 1, 1, 1);
        Canvas canvas2 = new Canvas();
        canvas2.setSize(15, 15);
        GridTools.constrain(this.contentPage, canvas2, 3, 6, 1, 1);
        Canvas canvas3 = new Canvas();
        canvas3.setSize(15, 1);
        GridTools.constrain(this.contentPage, canvas3, 5, 3, 1, 1);
        Canvas canvas4 = new Canvas();
        canvas4.setSize(10, 10);
        GridTools.constrain(this.contentPage, canvas4, 7, 11, 1, 1);
        this.filePage = new Panel();
        this.filePage.setLayout(new GridBagLayout());
        GridTools.constrain(this.filePage, new Label(tcmerge.locResource.getString("STR_IGNORE_UNIQUE_DIFF")), 2, 2, 1, 1, 0, 0, 17, 0);
        this.ignoreUniqueDifferencesChoice = new Choice();
        this.ignoreUniqueDifferencesChoice.add(tcmerge.locResource.getString("STR_BRACKETED_NONE"));
        this.ignoreUniqueDifferencesChoice.add(tcmerge.locResource.getString("STR_INPUT_FILE_1"));
        this.ignoreUniqueDifferencesChoice.add(tcmerge.locResource.getString("STR_INPUT_FILE_2"));
        this.ignoreUniqueDifferencesChoice.add(tcmerge.locResource.getString("STR_INPUT_FILE_3"));
        this.ignoreUniqueDifferencesChoice.select(this.ignoreUniqueDifferencesAnswer + 1);
        this.ignoreUniqueDifferencesChoice.addKeyListener(keyboardListener);
        GridTools.constrain(this.filePage, this.ignoreUniqueDifferencesChoice, 2, 3, 1, 1, 0, 0, 17, 2);
        if (this.numFiles == 2) {
            this.ignoreUniqueDifferencesChoice.setEnabled(false);
        }
        this.ignoreUniqueDifferencesOriginal = this.ignoreUniqueDifferencesChoice.getSelectedIndex() - 1;
        GridTools.constrain(this.filePage, new Label(tcmerge.locResource.getString("STR_PRIME_OUTPUT_FILE")), 4, 2, 1, 1, 0, 0, 17, 0);
        this.primeOutputFileChoice = new Choice();
        this.primeOutputFileChoice.add(tcmerge.locResource.getString("STR_BRACKETED_NONE"));
        this.primeOutputFileChoice.add(tcmerge.locResource.getString("STR_INPUT_FILE_1"));
        this.primeOutputFileChoice.add(tcmerge.locResource.getString("STR_INPUT_FILE_2"));
        if (this.numFiles == 3) {
            this.primeOutputFileChoice.add(tcmerge.locResource.getString("STR_INPUT_FILE_3"));
        }
        this.primeOutputFileChoice.select(this.primeOutputFileAnswer + 1);
        this.primeOutputFileOriginal = this.primeOutputFileChoice.getSelectedIndex() - 1;
        this.primeOutputFileChoice.addKeyListener(keyboardListener);
        GridTools.constrain(this.filePage, this.primeOutputFileChoice, 4, 3, 1, 1, 0, 0, 17, 2);
        this.automergeCheckbox = new Checkbox(tcmerge.locResource.getString("STR_AUTOMERGE"), this.automergeAnswer);
        this.automergeCheckbox.addKeyListener(keyboardListener);
        GridTools.constrain(this.filePage, this.automergeCheckbox, 2, 6, 1, 1, 0, 0, 17, 0);
        if (this.numFiles == 2) {
            this.automergeCheckbox.setEnabled(false);
        }
        ButtonPanel buttonPanel2 = new ButtonPanel(stringArray, new ButtonListener());
        buttonPanel2.addKeyListener(keyboardListener);
        GridTools.constrain(this.filePage, buttonPanel2, 3, 8, 2, 1, 0, 0, 13, 0);
        Canvas canvas5 = new Canvas();
        canvas5.setSize(10, 10);
        GridTools.constrain(this.filePage, canvas5, 1, 1, 1, 1);
        Canvas canvas6 = new Canvas();
        canvas6.setSize(75, 105);
        GridTools.constrain(this.filePage, canvas6, 3, 7, 1, 1);
        Canvas canvas7 = new Canvas();
        canvas7.setSize(10, 10);
        GridTools.constrain(this.filePage, canvas7, 5, 8, 1, 1);
        Canvas canvas8 = new Canvas();
        canvas8.setSize(1, 15);
        GridTools.constrain(this.filePage, canvas8, 2, 5, 1, 1);
        this.titlesPage = new Panel();
        this.titlesPage.setLayout(new GridBagLayout());
        ((Component)this.titlesPage).setFont(tcmerge.getDefaultFont());
        GridTools.constrain(this.titlesPage, new Label(tcmerge.locResource.getString("STR_TITLE_FOR_FILE1")), 2, 2, 1, 1, 0, 0, 17, 0);
        this.titlesTextField = new TextField[3];
        this.titlesTextField[0] = this.titlesAnswer.size() >= 1 ? new TextField((String)this.titlesAnswer.elementAt(0), 25) : new TextField(25);
        this.titlesTextField[0].setFont(tcmerge.getDefaultFont());
        GridTools.constrain(this.titlesPage, this.titlesTextField[0], 2, 3, 2, 1, 0, 0, 17, 0);
        GridTools.constrain(this.titlesPage, new Label(tcmerge.locResource.getString("STR_TITLE_FOR_FILE2")), 2, 4, 1, 1, 0, 0, 17, 0);
        this.titlesTextField[1] = this.titlesAnswer.size() >= 2 ? new TextField((String)this.titlesAnswer.elementAt(1), 25) : new TextField(25);
        this.titlesTextField[1].setFont(tcmerge.getDefaultFont());
        GridTools.constrain(this.titlesPage, this.titlesTextField[1], 2, 5, 2, 1, 0, 0, 17, 0);
        GridTools.constrain(this.titlesPage, new Label(tcmerge.locResource.getString("STR_TITLE_FOR_FILE3")), 2, 6, 1, 1, 0, 0, 17, 0);
        this.titlesTextField[2] = this.titlesAnswer.size() >= 3 ? new TextField((String)this.titlesAnswer.elementAt(2), 25) : new TextField(25);
        this.titlesTextField[2].setFont(tcmerge.getDefaultFont());
        GridTools.constrain(this.titlesPage, this.titlesTextField[2], 2, 7, 2, 1, 0, 0, 17, 0);
        ButtonPanel buttonPanel3 = new ButtonPanel(stringArray, new ButtonListener());
        buttonPanel3.addKeyListener(keyboardListener);
        GridTools.constrain(this.titlesPage, buttonPanel3, 4, 9, 1, 1);
        Canvas canvas9 = new Canvas();
        canvas9.setSize(10, 10);
        GridTools.constrain(this.titlesPage, canvas9, 1, 1, 1, 1);
        Canvas canvas10 = new Canvas();
        canvas10.setSize(30, 30);
        GridTools.constrain(this.titlesPage, canvas10, 3, 8, 1, 1);
        Canvas canvas11 = new Canvas();
        canvas11.setSize(10, 10);
        GridTools.constrain(this.titlesPage, canvas11, 5, 9, 1, 1);
        this.ntbk = new Notebook();
        this.setupNotebook();
        this.add(this.ntbk);
        Dimension dimension = this.parentFrame.getSize();
        Dimension dimension2 = this.getSize();
        try {
            Point point = this.parentFrame.getLocationOnScreen();
            ((Component)this).setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
            return;
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            Dimension dimension3 = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((dimension3.width - dimension2.width) / 2, (dimension3.height - dimension2.height) / 2);
            return;
        }
    }

    void setupNotebook() {
        String string = tcmerge.locResource.getString("STR_CONTENT");
        this.ntbk.addPage(string, this.contentPage, null);
        string = tcmerge.locResource.getString("STR_FILE");
        this.ntbk.addPage(string, this.filePage, null);
        string = tcmerge.locResource.getString("STR_TITLES");
        this.ntbk.addPage(string, this.titlesPage, null);
        this.contentPage.setVisible(true);
    }

    public void setNumFiles(int n) {
        this.numFiles = n;
        if (n == 2) {
            this.automergeCheckbox.setEnabled(false);
            this.ignoreUniqueDifferencesChoice.setEnabled(false);
            if (this.primeOutputFileChoice.getItemCount() == 4) {
                this.primeOutputFileChoice.remove(tcmerge.locResource.getString("STR_INPUT_FILE_3"));
                return;
            }
        } else {
            this.automergeCheckbox.setEnabled(true);
            this.ignoreUniqueDifferencesChoice.setEnabled(true);
            if (this.primeOutputFileChoice.getItemCount() == 3) {
                this.primeOutputFileChoice.add(tcmerge.locResource.getString("STR_INPUT_FILE_3"));
            }
        }
    }

    public String getAction() {
        return this.action;
    }

    public boolean recalculateNeeded() {
        return this.recalculate;
    }

    public String getIgnoreBlanksAnswer() {
        return this.ignoreBlanksAnswer;
    }

    public void setIgnoreBlanksAnswer(String string) {
        this.ignoreBlanksAnswer = string;
    }

    public int getIgnoreUniqueDifferencesAnswer() {
        return this.ignoreUniqueDifferencesAnswer;
    }

    public void setIgnoreUniqueDifferencesAnswer(int n) {
        this.ignoreUniqueDifferencesAnswer = n;
    }

    public int getPrimeOutputFileAnswer() {
        return this.primeOutputFileAnswer;
    }

    public void setPrimeOutputFileAnswer(int n) {
        this.primeOutputFileAnswer = n;
    }

    public Vector getColumnsToIgnoreAnswer() {
        return this.columnsToIgnoreAnswer;
    }

    public void setColumnsToIgnoreAnswer(Vector vector) {
        this.columnsToIgnoreAnswer = vector;
    }

    public String getIgnoreCaseSensitiveAnswer() {
        return this.ignoreCaseSensitiveAnswer;
    }

    public void setIgnoreCaseSensitiveAnswer(String string) {
        this.ignoreCaseSensitiveAnswer = string;
        if (this.ignoreCaseSensitiveAnswer.equals("-i")) {
            this.ignoreCaseSensitiveBoolean = true;
            return;
        }
        this.ignoreCaseSensitiveBoolean = false;
    }

    public boolean getAutomergeAnswer() {
        return this.automergeAnswer;
    }

    public void setAutomergeAnswer(boolean bl) {
        this.automergeAnswer = bl;
    }

    public String getIgnoreBlankLinesAnswer() {
        if (this.ignoreBlankLinesAnswer) {
            return "-B";
        }
        return "";
    }

    public void setIgnoreBlankLinesAnswer(String string) {
        if (string.equals("-B")) {
            this.ignoreBlankLinesAnswer = true;
            return;
        }
        this.ignoreBlankLinesAnswer = false;
    }

    public Vector getTitlesAnswer() {
        return this.titlesAnswer;
    }

    public void setTitlesAnswer(Vector vector) {
        this.titlesAnswer = vector;
    }

    public void addEvent() {
        if (this.modalOn) {
            return;
        }
        String string = this.ignoreColumnsTextField.getText();
        if ((string = StringTools.stripChar(string, ' ')).length() == 0) {
            return;
        }
        try {
            if (Validate.rangesToIgnoreValid(string)) {
                this.recalculate = true;
                this.rangesToIgnoreList.add(string);
                ((TextComponent)this.ignoreColumnsTextField).setText("");
                this.addButton.setEnabled(false);
                return;
            }
            throw new TCMergeException(5, string);
        }
        catch (TCMergeException tCMergeException) {
            WarningDialog warningDialog = new WarningDialog(this.parentFrame, tCMergeException.toString());
            this.modalOn = true;
            warningDialog.show();
            this.modalOn = false;
            warningDialog.dispose();
            return;
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        Vector vector;
        Vector vector2;
        int n3 = -1;
        int n4 = -1;
        int n5 = stringArray.length;
        int n6 = 0;
        while (n6 < stringArray.length) {
            if (stringArray[n6].equals("-primeout")) {
                stringArray[n6] = "";
                n3 = new Integer(stringArray[n6 + 1]);
                stringArray[n6 + 1] = "";
                n5 -= 2;
            }
            if (stringArray[n6].equals("-ignoreunique")) {
                stringArray[n6] = "";
                n4 = new Integer(stringArray[n6 + 1]);
                stringArray[n6 + 1] = "";
                n5 -= 2;
            }
            ++n6;
        }
        String[] stringArray2 = new String[n5];
        int n7 = 0;
        int n8 = 0;
        while (n8 < stringArray.length) {
            if (!stringArray[n8].equals("")) {
                stringArray2[n7++] = stringArray[n8];
            }
            ++n8;
        }
        tcmerge tcmerge2 = new tcmerge();
        tcmerge2.parseCmdLine(stringArray2);
        DiffInput diffInput = tcmerge2.getDiffInput();
        diffInput.setPrimeOutput(n3);
        diffInput.setIgnoreDiff(n4);
        Frame frame = new Frame();
        MergeOptionsDialog mergeOptionsDialog = new MergeOptionsDialog(frame, 3);
        mergeOptionsDialog.setIgnoreBlanksAnswer(diffInput.getIgnoreBlanks());
        mergeOptionsDialog.setIgnoreUniqueDifferencesAnswer(diffInput.getIgnoreDiff());
        mergeOptionsDialog.setPrimeOutputFileAnswer(diffInput.getPrimeOutput());
        mergeOptionsDialog.setColumnsToIgnoreAnswer(diffInput.getColsToIgnore());
        mergeOptionsDialog.setIgnoreCaseSensitiveAnswer(diffInput.getIgnoreCaseSensitive());
        mergeOptionsDialog.setAutomergeAnswer(diffInput.getAutomerge());
        mergeOptionsDialog.setIgnoreBlankLinesAnswer(diffInput.getIgnoreBlankLines());
        mergeOptionsDialog.setTitlesAnswer(diffInput.getTitles());
        mergeOptionsDialog.createDialog();
        mergeOptionsDialog.show();
        String string = new String("");
        String string2 = mergeOptionsDialog.getIgnoreBlanksAnswer();
        if (string2.equals("-l")) {
            string = String.valueOf(string) + "-ignoreblanks L ";
        } else if (string2.equals("-t")) {
            string = String.valueOf(string) + "-ignoreblanks T ";
        } else if (string2.equals("-l -t")) {
            string = String.valueOf(string) + "-ignoreblanks LT ";
        } else if (string2.equals("-w")) {
            string = String.valueOf(string) + "-ignoreblanks A ";
        }
        if (mergeOptionsDialog.getIgnoreCaseSensitiveAnswer().equals("-i")) {
            string = String.valueOf(string) + "-ignorecase ";
        }
        if (mergeOptionsDialog.getIgnoreBlankLinesAnswer().equals("-B")) {
            string = String.valueOf(string) + "-ignoreblanklines ";
        }
        if (mergeOptionsDialog.getAutomergeAnswer()) {
            string = String.valueOf(string) + "-automerge ";
        }
        if ((vector2 = mergeOptionsDialog.getTitlesAnswer()).size() > 0) {
            string = String.valueOf(string) + "-titles ";
            int n9 = 0;
            while (n9 < vector2.size()) {
                string = String.valueOf(string) + (String)vector2.elementAt(n9);
                string = String.valueOf(string) + " ";
                ++n9;
            }
        }
        if ((vector = mergeOptionsDialog.getColumnsToIgnoreAnswer()).size() > 0) {
            string = String.valueOf(string) + "-ignorecolumns ";
            n2 = 0;
            while (n2 < vector.size()) {
                string = String.valueOf(string) + (String)vector.elementAt(n2);
                string = String.valueOf(string) + " ";
                ++n2;
            }
        }
        if ((n2 = mergeOptionsDialog.getPrimeOutputFileAnswer()) != -1) {
            string = String.valueOf(string) + "-primeout " + new Integer(n2).toString() + " ";
        }
        if ((n = mergeOptionsDialog.getIgnoreUniqueDifferencesAnswer()) != -1) {
            string = String.valueOf(string) + "-ignoreunique " + new Integer(n).toString() + " ";
        }
        if (mergeOptionsDialog.getAction().equals("OK")) {
            System.out.println(string);
        } else {
            System.out.println("CANCEL");
        }
        System.exit(0);
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
            MergeOptionsDialog.this = MergeOptionsDialog.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Add")) {
                MergeOptionsDialog.this.addEvent();
                return;
            }
            if (string.equals("Remove")) {
                String[] stringArray = MergeOptionsDialog.this.rangesToIgnoreList.getSelectedItems();
                int n = 0;
                while (n < stringArray.length) {
                    MergeOptionsDialog.this.recalculate = true;
                    MergeOptionsDialog.this.rangesToIgnoreList.remove(stringArray[n]);
                    if (MergeOptionsDialog.this.rangesToIgnoreList.getItemCount() == 0) {
                        MergeOptionsDialog.this.removeButton.setEnabled(false);
                    }
                    ++n;
                }
                return;
            }
            if (string.equals("OK")) {
                if (MergeOptionsDialog.this.modalOn) {
                    return;
                }
                try {
                    if (MergeOptionsDialog.this.automergeCheckbox.getState() && MergeOptionsDialog.this.ignoreUniqueDifferencesChoice.getSelectedIndex() != 0) {
                        throw new TCMergeException(34);
                    }
                }
                catch (TCMergeException tCMergeException) {
                    WarningDialog warningDialog = new WarningDialog(MergeOptionsDialog.this.parentFrame, tCMergeException.toString());
                    MergeOptionsDialog.this.modalOn = true;
                    warningDialog.show();
                    MergeOptionsDialog.this.modalOn = false;
                    warningDialog.dispose();
                    return;
                }
                String string2 = MergeOptionsDialog.this.ignoreBlanksAnswer;
                String string3 = MergeOptionsDialog.this.ignoreBlanksChoice.getSelectedItem();
                MergeOptionsDialog.this.ignoreBlanksAnswer = string3.equals(tcmerge.locResource.getString("STR_IGNORE_BLANKS_LEADING")) ? "-l" : (string3.equals(tcmerge.locResource.getString("STR_IGNORE_BLANKS_TRAILING")) ? "-t" : (string3.equals(tcmerge.locResource.getString("STR_IGNORE_BLANKS_BOTH")) ? "-l -t" : (string3.equals(tcmerge.locResource.getString("STR_IGNORE_BLANKS_ALL")) ? "-w" : "")));
                if (!MergeOptionsDialog.this.ignoreBlanksAnswer.equals(string2)) {
                    MergeOptionsDialog.this.recalculate = true;
                }
                MergeOptionsDialog.this.ignoreUniqueDifferencesAnswer = MergeOptionsDialog.this.ignoreUniqueDifferencesChoice.getSelectedIndex() - 1;
                MergeOptionsDialog.this.primeOutputFileAnswer = MergeOptionsDialog.this.primeOutputFileChoice.getSelectedIndex() - 1;
                if (MergeOptionsDialog.this.primeOutputFileAnswer != MergeOptionsDialog.this.primeOutputFileOriginal || MergeOptionsDialog.this.ignoreUniqueDifferencesAnswer != MergeOptionsDialog.this.ignoreUniqueDifferencesOriginal) {
                    MergeOptionsDialog.this.recalculate = true;
                }
                if (MergeOptionsDialog.this.ignoreCaseSensitiveBoolean != MergeOptionsDialog.this.ignoreCaseSensitiveCheckbox.getState()) {
                    boolean bl = MergeOptionsDialog.this.ignoreCaseSensitiveCheckbox.getState();
                    MergeOptionsDialog.this.ignoreCaseSensitiveAnswer = bl ? "-i" : "";
                    MergeOptionsDialog.this.recalculate = true;
                }
                if (MergeOptionsDialog.this.automergeAnswer != MergeOptionsDialog.this.automergeCheckbox.getState()) {
                    MergeOptionsDialog.this.automergeAnswer = MergeOptionsDialog.this.automergeCheckbox.getState();
                    MergeOptionsDialog.this.recalculate = true;
                }
                if (MergeOptionsDialog.this.ignoreBlankLinesAnswer != MergeOptionsDialog.this.ignoreBlankLinesCheckbox.getState()) {
                    MergeOptionsDialog.this.ignoreBlankLinesAnswer = MergeOptionsDialog.this.ignoreBlankLinesCheckbox.getState();
                    MergeOptionsDialog.this.recalculate = true;
                }
                if (MergeOptionsDialog.this.titlesAnswer.size() >= 1) {
                    MergeOptionsDialog.this.titlesAnswer.setElementAt(MergeOptionsDialog.this.titlesTextField[0].getText(), 0);
                } else {
                    MergeOptionsDialog.this.titlesAnswer.addElement(MergeOptionsDialog.this.titlesTextField[0].getText());
                }
                if (MergeOptionsDialog.this.titlesAnswer.size() >= 2) {
                    MergeOptionsDialog.this.titlesAnswer.setElementAt(MergeOptionsDialog.this.titlesTextField[1].getText(), 1);
                } else {
                    MergeOptionsDialog.this.titlesAnswer.addElement(MergeOptionsDialog.this.titlesTextField[1].getText());
                }
                if (MergeOptionsDialog.this.titlesAnswer.size() >= 3) {
                    MergeOptionsDialog.this.titlesAnswer.setElementAt(MergeOptionsDialog.this.titlesTextField[2].getText(), 2);
                } else {
                    MergeOptionsDialog.this.titlesAnswer.addElement(MergeOptionsDialog.this.titlesTextField[2].getText());
                }
                if (MergeOptionsDialog.this.titlesTextField[0].getText().equals("") || MergeOptionsDialog.this.titlesTextField[1].getText().equals("")) {
                    MergeOptionsDialog.this.titlesAnswer = new Vector();
                }
                MergeOptionsDialog.this.columnsToIgnoreAnswer = new Vector();
                String[] stringArray = MergeOptionsDialog.this.rangesToIgnoreList.getItems();
                int n = 0;
                while (n < stringArray.length) {
                    MergeOptionsDialog.this.columnsToIgnoreAnswer.addElement(stringArray[n]);
                    ++n;
                }
                MergeOptionsDialog.this.action = "OK";
                ((Component)MergeOptionsDialog.this).setVisible(false);
                return;
            }
            if (string.equals("Cancel")) {
                if (MergeOptionsDialog.this.modalOn) {
                    return;
                }
                MergeOptionsDialog.this.action = "CANCEL";
                ((Component)MergeOptionsDialog.this).setVisible(false);
                return;
            }
            if (string.equals("Help")) {
                TCMergeHelp.showHelp(MergeOptionsDialog.this.parentFrame, "HDRFILE100");
            }
        }
    }

    class KeyboardListener
    extends KeyAdapter {
        KeyboardListener() {
            MergeOptionsDialog.this = MergeOptionsDialog.this;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                if (MergeOptionsDialog.this.modalOn) {
                    return;
                }
                MergeOptionsDialog.this.action = "CANCEL";
                ((Component)MergeOptionsDialog.this).setVisible(false);
            }
        }
    }

    class TextFieldKeyListener
    extends KeyAdapter {
        String action;

        TextFieldKeyListener(String string) {
            MergeOptionsDialog.this = MergeOptionsDialog.this;
            this.action = string;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && this.action.equals("Add")) {
                MergeOptionsDialog.this.addEvent();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (MergeOptionsDialog.this.ignoreColumnsTextField.getText().length() != 0) {
                MergeOptionsDialog.this.addButton.setEnabled(true);
                return;
            }
            MergeOptionsDialog.this.addButton.setEnabled(false);
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (MergeOptionsDialog.this.ignoreColumnsTextField.getText().length() != 0) {
                MergeOptionsDialog.this.addButton.setEnabled(true);
                return;
            }
            MergeOptionsDialog.this.addButton.setEnabled(false);
        }
    }

    class ListListener
    implements ItemListener {
        ListListener() {
            MergeOptionsDialog.this = MergeOptionsDialog.this;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (MergeOptionsDialog.this.rangesToIgnoreList.getSelectedItems().length == 0) {
                MergeOptionsDialog.this.removeButton.setEnabled(false);
                return;
            }
            MergeOptionsDialog.this.removeButton.setEnabled(true);
        }
    }

    class DialogListener
    extends WindowAdapter {
        int aixkluge;

        public void windowClosing(WindowEvent windowEvent) {
            if (MergeOptionsDialog.this.modalOn) {
                return;
            }
            MergeOptionsDialog.this.action = "CANCEL";
            ((Component)MergeOptionsDialog.this).setVisible(false);
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (this.aixkluge == 0) {
                MergeOptionsDialog.this.ignoreColumnsTextField.requestFocus();
            }
            this.aixkluge = 1;
        }

        DialogListener() {
            MergeOptionsDialog.this = MergeOptionsDialog.this;
        }
    }
}

