/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcadmin;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.text.BreakIterator;
import javax.swing.Box;
import javax.swing.JLabel;

public class JMultiLineLabel
extends Box {
    protected JLabel[] labels;
    protected String[] lines;
    protected String[] words;
    protected String text;
    protected int num_lines;
    protected int num_words;
    protected int num_chars;
    protected int margin_width;
    protected int margin_height;
    protected int line_height;
    protected int max_width;
    protected int alignment = 2;
    protected int comp_width;
    protected int comp_height;
    protected Component parent;
    protected boolean resizing;
    protected Insets insets;
    protected boolean measured = false;

    protected void newLabel(String string) {
        this.text = string;
        this.measured = false;
    }

    protected void measure() {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        if (!this.isShowing()) {
            return;
        }
        if (fontMetrics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        if (dimension.height == 0 || dimension.width == 0) {
            dimension = ((Container)this).getMaximumSize();
        }
        if (dimension.height == 0 || dimension.width == 0) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
        }
        if (dimension.height == 0 || dimension.width == 0) {
            return;
        }
        int n = 0;
        while (n < this.num_lines) {
            this.remove(this.labels[n]);
            this.labels[n] = null;
            ++n;
        }
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(this.text);
        String string = this.text;
        int n2 = 0;
        this.comp_width = dimension.width;
        this.comp_height = dimension.height;
        this.line_height = fontMetrics.getHeight();
        this.line_height += fontMetrics.getLeading();
        this.num_lines = dimension.height / this.line_height + 1;
        this.lines = new String[this.num_lines + 10];
        this.max_width = dimension.width - 2 * this.margin_width;
        n = 0;
        while (n2 < breakIterator.last()) {
            int n3 = this.text.indexOf(10, n2);
            if (n3 != -1) {
                string = this.text.substring(n2, n3);
                ++n3;
                if (fontMetrics.stringWidth(string) > this.max_width) {
                    n3 = -1;
                }
            }
            if (n3 == -1) {
                string = this.text.substring(n2);
                n3 = breakIterator.last();
                while (fontMetrics.stringWidth(string) > this.max_width) {
                    n3 = breakIterator.previous();
                    string = this.text.substring(n2, n3);
                }
            }
            this.lines[n] = string;
            n2 = n3;
            ++n;
        }
        this.num_lines = n;
        this.labels = new JLabel[this.num_lines];
        n = 0;
        while (n < this.num_lines) {
            this.labels[n] = new JLabel(this.lines[n], null, this.alignment);
            this.labels[n].setFont(this.getFont());
            this.add(this.labels[n]);
            this.labels[n].setVisible(true);
            ++n;
        }
        int n4 = this.num_lines * this.line_height;
        if (!this.measured) {
            this.measured = true;
            this.invalidate();
            this.parent.validate();
        }
        if (n4 > dimension.height && !this.resizing) {
            this.resizing = true;
            dimension.height = this.num_lines * this.line_height;
            this.setSize(dimension);
            this.invalidate();
            this.parent.validate();
            this.resizing = false;
        }
        this.measured = true;
    }

    public JMultiLineLabel(Component component, String string, int n, int n2, int n3) {
        super(1);
        this.newLabel(string);
        this.margin_width = n;
        this.margin_height = n2;
        this.alignment = n3;
        this.parent = component;
        this.insets = new Insets(n2, n, n2, n);
        this.num_lines = 0;
        this.resizing = false;
    }

    public JMultiLineLabel(Component component, String string, int n, int n2) {
        this(component, string, n, n2, 2);
    }

    public JMultiLineLabel(Component component, String string, int n) {
        this(component, string, 10, 10, n);
    }

    public JMultiLineLabel(Component component, String string) {
        this(component, string, 10, 10, 2);
    }

    public void setLabel(String string) {
        this.newLabel(string);
        this.measure();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.measure();
    }

    public void setAlignment(int n) {
        this.alignment = n;
        int n2 = 0;
        while (n2 < this.num_lines) {
            this.labels[n2].setHorizontalAlignment(n);
            ++n2;
        }
    }

    public void setMarginWidth(int n) {
        this.margin_width = n;
        this.insets.left = n;
        this.insets.right = n;
    }

    public void setMarginHeight(int n) {
        this.margin_height = n;
        this.insets.top = n;
        this.insets.bottom = n;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.margin_width;
    }

    public int getMarginHeight() {
        return this.margin_height;
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.measure();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.measure();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width != this.comp_width || dimension.height != this.comp_height) {
            this.measure();
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return super.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        if (!this.measured) {
            this.measure();
        }
        super.paint(graphics);
    }
}

