/*------------------------------------------------------*/
/* PROGRAM NAME:  FHBPARSE.C                            */
/* IBM Sample C parser TeamConnection                   */
/*                                                      */
/*------------------------------------------------------*/
/*                 IBM TeamConnection                   */
/*                 Version 2 Release 0                  */
/*                    5622-717                          */
/*                                                      */
/* (C) Copyright, IBM Corp., 1996. All Rights Reserved. */
/*          Licensed Materials - Property of IBM        */
/*         US Government Users Restricted Rights        */
/*  - Use, duplication or disclosure restricted by      */
/*      GSA ADP Schedule Contract with IBM Corp.        */
/*                                                      */
/*          IBM is a registered trademark of            */
/*     International Business Machines Corporation      */
/*                                                      */
/* DISCLAIMER OF WARRANTIES:                            */
/*  The following enclosed code is sample code created  */
/*  by IBM Corporation.  This sample code is not part of*/
/*  any standard product and is provided to you solely  */
/*  for the purpose of assisting you in the development */
/*  of your applications.  The code is provide "AS IS", */
/*  without warranty of any kind. IBM shall not be      */
/*  liable for any damages arising out of your use      */
/*  of the sample code                                  */
/*                                                      */
/*********************************************************************************/
/* Limited Edition: Basic Parsing Function                                       */
/*                  Limited Error checking                                       */
/*                  Avoids recursive include files                               */
/* Program Function: This program is designed to parse lines of text in ASCII    */
/*                   files specified as an argument when the program is          */
/*                   invoked. The program takes any Os/2 FAT file scheme valid   */
/*                   file name and file extension. IF extension is omitted,      */
/*                   file extension of C is assumed. In each line of the input   */
/*                   file the program looks for #include <filename.ext> or       */
/*                   #include "filename.ext" pattern. If found, the string is    */
/*                   parsed and the file name with file extension extracted.     */
/*                   If output filename is specified then it is used, otherwise, */
/*                   the output is stored in FILE.OUT                            */
/*                   This process continues until all the logged files are read. */
/***                                                                             */
/*** Program Requirement:                                                        */
/***  Language Used:  C                                                          */
/*** Program Invocation:  Parser Input Parameter                                 */
/*** INPUT Parameter:     Filename.extn familyname releasename workareaname      */
/*** FileName: Any OS/2 valid File name with valid extension                     */
/***  OUTPUT:  FILE.OUT This is the file that contains the parsed                */
/***                   List.                                                     */
/*********************************************************************************/


#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define MAX_LINE_LEN   256
#define INCLUDE_TEXT   "#INCLUDE"

#if defined(__UNIX__)
#define strnicmp strncasecmp
#endif

int main(int argc, char *argv[])
{
  int     rc=0;
  FILE   *fpIn,  *fpOut;
  char    line[MAX_LINE_LEN] = "";
  char   *parseline = NULL;
  char   temp[255]="";

  /* set default output file name if not specified */
  if ( argc > 2 )
    fpOut = fopen(argv[2], "w");
  else
    fpOut = fopen("FILE.OUT", "w");

  /* open input arg for read */
  if ( (fpIn = fopen(argv[1], "r")) == NULL)
  {
    return 38;
  }

  parseline = fgets(line, MAX_LINE_LEN, fpIn);
  /* read until end of file or error */
  while ( !(feof(fpIn)) && !(ferror(fpIn)) )
  {
    while ( !strncmp(parseline, " ", 1) )
      parseline++;

    if (!strncmp(parseline, "#", 1))
    {
      if ( !strnicmp(parseline,INCLUDE_TEXT,strlen(INCLUDE_TEXT)) ) {
        if ( strchr(parseline, '<') != NULL ) {
          /* if the matching > is on the same line */
          if ( strchr(parseline, '>') != NULL )
          {
            strcpy(temp, strchr(parseline, '<') + 1 );
            *strchr(temp, '>') = '\0';
            strcat(temp, "\n");
            fputs(temp, fpOut);
          }
        }
        else if ( strchr(parseline, '"') != NULL ) {
          /* if the matching " is on the same line */
          if ( strchr(parseline, '"') != NULL )
          {
            strcpy(temp, strchr(parseline, '"') + 1 );
            *strchr(temp, '"') = '\0';
            strcat(temp, "\n");
            fputs(temp, fpOut);
          }
        }
      }
    }

    parseline = fgets(line, MAX_LINE_LEN, fpIn);
  }

  if (fpIn)
    fclose(fpIn);

  if (fpOut)
    fclose(fpOut);

  return rc;
}
