//*------------------------------------------------------
//* PROGRAM:  FHBTCLNK
//* TeamConection Object Collector for MVS Sample 
//*          TeamConnection Build Script
//*                                                      
//* Collect Object Files and control statements
//* into one large dataset
//*
//*              IBM TeamConnection for OS/2
//*                     Version 1 Release 0
//*
//*                       5622-717
//*    (C) Copyright, IBM Corp., 1995. All Rights Reserved.
//*             Licensed Materials - Property of IBM
//*
//*         US Government Users Restricted Rights
//*     - Use, duplication or disclosure restricted by
//*         GSA ADP Schedule Contract with IBM Corp.
//*
//*              IBM is a registered trademark of
//*        International Business Machines Corporation
//*                                                      
//* DISCLAIMER OF WARRANTIES:                            
//*  The following enclosed code is sample code created  
//*  by IBM Corporation.  This sample code is not part   
//*  any standard product and is provided to you solely  
//*  for the purpose of assisting you in the development 
//*  of your applications.  The code is provide "AS IS", 
//*  without warranty of any kind. IBM shall not be      
//*  liable for any damages arising out of your use      
//*  of the sample code                                  
//*------------------------------------------------------ 
//*
//* MVS Load modules are not easily transferable
//* between operating systems.  To bypass this MVS
//* limitation, TeamConnection has provided a
//* program that reads linkage editor SYSLIN
//* control statements.  If the card is an
//* INCLUDE OBJ(MEMBER) control statement, then
//* the object code is copied into a sequential
//* dataset associated with the SYSMOD DDName.
//* Otherwise, the control card is imbedded in the
//* dataset associated with the SYSMOD DDName.
//* This dataset can be returned as the output
//* using this build script.
//*
//* The TC syntax for an INCLUDE
//* control statement for FHBTCLNK is
//*     "INCLUDE DDNAME(MEMBER)" or
//*     "INCLUDE DDNAME"
//* This is a subset of the linkage editor include card
//*
//* To use this output as a MVS executable:
//*  1) Extract the output from TeamConnection
//*  2) Transfer the output as a binary file
//*     to MVS. (for example, using FTP)
//*  3) Linkedit this output into a load
//*     module.  Possible SYSLIN control
//*     statements for the link step:
//*     //SYSLIN DD *
//*       INCLUDE OBJECT(OUTPUT)
//*       NAME module(R)
//*     //
//*  Remember this output contains imbedded control statements
//*  specified in this build script.  The linkage editor
//*  recognizes these imbedded statements. The NAME control
//*  statement can not be imbedded in the output dataset.
//*  
//*  Some dataset names may need to be modified
//*  according to your system's customization
//*------------------------------------------------------ 
//FHBTCLNK  EXEC  PGM=FHBTCLNK
//STEPLIB DD DSN=userid.teamc.LOADLIB,DISP=SHR
//*SYSMOD must be a sequential dataset, recfm=FB
//* and lrecl=80
//SYSMOD   DD  TCEXT=LOAD,DISP=(NEW,DELETE),
//    UNIT=VIO,SPACE=(32000,(30,10)),
//    DCB=(RECFM=FB,LRECL=80,BLKSIZE=3200)
//OBJ      DD  TCEXT=(OBJ,PRE),DISP=(NEW,DELETE),
//    UNIT=VIO,SPACE=(32000,(30,10,10)),
//    DCB=(RECFM=FB,LRECL=80,BLKSIZE=3200)
//SYSPRINT DD  TCEXT=TCOUT,DISP=(NEW,DELETE),
//   UNIT=VIO,SPACE=(TRK,(30,10)),
//  DCB=(RECFM=FB,LRECL=121,BLKSIZE=1210)
//SYSLIN   DD  *
 INCLUDE OBJ(&TCINPUT)
 ENTRY CEESTART
//
