/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.LegendCanvas;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class Legend
extends Dialog {
    LegendCanvas legendCanvas;
    Frame parentFrame;
    int width;
    int height;
    Font font;
    int numOfFiles;
    String[] filenames;
    Color[] fgColors;
    Color[] bgColors;

    public Legend(Frame frame, String[] stringArray, Color[] colorArray, Color[] colorArray2, Font font) {
        super(frame, tcmerge.locResource.getString("ITEM_LEGEND"));
        this.parentFrame = frame;
        this.font = font;
        this.filenames = stringArray;
        this.fgColors = colorArray2;
        this.bgColors = colorArray;
        this.createLegend();
    }

    public Legend(Frame frame, String[] stringArray, Color[] colorArray, Color[] colorArray2) {
        super(frame, tcmerge.locResource.getString("ITEM_LEGEND"));
        this.parentFrame = frame;
        this.numOfFiles = stringArray.length;
        this.filenames = stringArray;
        this.fgColors = colorArray2;
        this.bgColors = this.bgColors;
        this.font = new Font("Dialog", 0, 14);
        this.createLegend();
    }

    public Legend(Frame frame, String[] stringArray, Color[] colorArray, Color[] colorArray2, WindowListener windowListener) {
        super(frame, tcmerge.locResource.getString("ITEM_LEGEND"));
        this.parentFrame = frame;
        this.numOfFiles = stringArray.length;
        this.filenames = stringArray;
        this.fgColors = colorArray2;
        this.bgColors = colorArray;
        this.font = new Font("Dialog", 0, 14);
        this.addWindowListener(windowListener);
        this.createLegend();
    }

    public void setFont(Font font) {
        this.font = font;
        this.figureSize();
    }

    public void updateLegend(String[] stringArray, Color[] colorArray, Color[] colorArray2) {
        this.filenames = stringArray;
        this.fgColors = colorArray2;
        this.bgColors = colorArray;
        this.numOfFiles = stringArray.length;
        this.legendCanvas.updateLegendCanvas(this.font, stringArray, colorArray, colorArray2);
        this.figureSize();
    }

    private void createLegend() {
        DialogListener dialogListener = new DialogListener();
        this.addWindowListener(dialogListener);
        KeyboardListener keyboardListener = new KeyboardListener();
        this.addKeyListener(keyboardListener);
        this.setFont(this.font);
        this.setResizable(false);
        this.legendCanvas = new LegendCanvas(this.font, this.filenames, this.bgColors, this.fgColors);
        this.legendCanvas.addKeyListener(keyboardListener);
        this.add(this.legendCanvas);
        Dimension dimension = this.parentFrame.getSize();
        Dimension dimension2 = this.getSize();
        Point point = this.parentFrame.getLocationOnScreen();
        Dimension dimension3 = this.getToolkit().getScreenSize();
        Point point2 = new Point();
        point2.x = point.x + (dimension.width - dimension2.width) / 2;
        point2.y = point.y + dimension.height + 40;
        if (point2.y + dimension2.height > dimension3.height) {
            point2.y = dimension3.height - dimension2.height;
        }
        if (point2.x < 0) {
            point2.x = 0;
        }
        if (point2.x > dimension3.width - dimension2.width) {
            point2.x = dimension3.width - dimension2.width;
        }
        ((Component)this).setLocation(point2);
    }

    private void figureSize() {
        this.height = 0;
        this.width = 0;
        Toolkit toolkit = this.getToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(this.font);
        int n = fontMetrics.getHeight() + 2;
        this.height = this.numOfFiles * n + 30;
        int n2 = 0;
        while (n2 < this.numOfFiles) {
            int n3 = fontMetrics.stringWidth(this.filenames[n2]);
            if (n3 > this.width) {
                this.width = n3;
            }
            ++n2;
        }
        this.width += 20;
        if (this.width < 200) {
            this.width = 200;
        }
        ((Component)this).setSize(this.width, this.height);
    }

    public void triggerWindowClosingEvents() {
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    class DialogListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)Legend.this).setVisible(false);
        }

        DialogListener() {
            Legend.this = Legend.this;
        }
    }

    class KeyboardListener
    implements KeyListener {
        KeyboardListener() {
            Legend.this = Legend.this;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                Legend.this.triggerWindowClosingEvents();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

