/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.ConvertColors;
import com.ibm.vatc.tcmerge.MergeGui;
import com.ibm.vatc.tcmerge.Options;
import com.ibm.vatc.tcmerge.ViewParam;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class IOProperties {
    File propertyFile;
    Vector schemeNames;
    String lastUsedScheme;
    MergeGui mg;
    Options options;
    ConvertColors cc;
    ViewParam viewParam;
    public Properties propSettings;

    IOProperties(MergeGui mergeGui) {
        this.mg = mergeGui;
        this.options = this.mg.getOptions();
        this.cc = new ConvertColors();
        this.schemeNames = new Vector();
        this.viewParam = this.mg.getViewParam();
        this.propSettings = new Properties();
        this.getPropertyScheme();
    }

    public int setPropertiesFileName() {
        String string = System.getProperty("user.home");
        File file = new File(string);
        this.propertyFile = new File(file, ".tcmrgpr.txt");
        if (this.propertyFile.exists()) {
            return 0;
        }
        return -1;
    }

    public File getPropertiesFile() {
        return this.propertyFile;
    }

    public void setLastUsedScheme(String string) {
        ((Hashtable)this.propSettings).put("lastusedschemename", string);
        this.lastUsedScheme = string;
    }

    public String getLastUsedScheme() {
        String string = this.propSettings.getProperty("lastusedschemename", tcmerge.locResource.getString("STR_MERGEDEFAULT"));
        return string;
    }

    public Vector getSchemeNames() {
        this.schemeNames.removeAllElements();
        String string = this.propSettings.getProperty("schemenames", tcmerge.locResource.getString("STR_MERGEDEFAULT"));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "$$$");
        while (stringTokenizer.hasMoreTokens()) {
            this.schemeNames.addElement(stringTokenizer.nextToken());
        }
        return this.schemeNames;
    }

    public Properties getProperties() {
        return this.propSettings;
    }

    public void LoadPropertyFile() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.propertyFile);
            this.propSettings.load(fileInputStream);
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
    }

    public void SavePropertyFile() {
        String string = "";
        int n = 0;
        while (n < this.schemeNames.size()) {
            string = String.valueOf(string) + "$$$" + this.schemeNames.elementAt(n);
            ((Hashtable)this.propSettings).put("schemenames", string);
            ++n;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.propertyFile);
            this.propSettings.save(fileOutputStream, "Visual Merge Properties File");
            fileOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
    }

    public void getPropertyScheme() {
        this.lastUsedScheme = this.propSettings.getProperty("lastusedschemename", tcmerge.locResource.getString("STR_MERGEDEFAULT"));
        this.options.getEditor().setSchemeName(this.lastUsedScheme);
        this.options.getEditor().setFontName(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".fontname", "SansSerif"));
        this.options.getEditor().setFontSize(Integer.parseInt(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".fontsize", "12")));
        this.options.getEditor().setTab(Integer.parseInt(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".tabsize", "8")));
        this.options.getEditor().setZerothCurrentDiffFG(this.cc.ConvertStringToColor(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".zerothcurrentdifffg", this.cc.ConvertColorToString(Color.white))));
        this.options.getEditor().setZerothDiffcolor(this.cc.ConvertStringToColor(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".zerothdiff", this.cc.ConvertColorToString(this.cc.burgundy))));
        this.options.getEditor().setFirstCurrentDiffFG(this.cc.ConvertStringToColor(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".firstcurrentdifffg", this.cc.ConvertColorToString(Color.white))));
        this.options.getEditor().setFirstDiffColor(this.cc.ConvertStringToColor(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".firstdiff", this.cc.ConvertColorToString(this.cc.steelblue))));
        this.options.getEditor().setSecondCurrentDiffFG(this.cc.ConvertStringToColor(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".secondcurrentdifffg", this.cc.ConvertColorToString(Color.white))));
        this.options.getEditor().setSecondDiffColor(this.cc.ConvertStringToColor(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".seconddiff", this.cc.ConvertColorToString(this.cc.brightblue))));
        this.options.getEditor().setMatchedForeground(this.cc.ConvertStringToColor(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".matchedforground", this.cc.ConvertColorToString(this.cc.mediumgray))));
        this.options.getEditor().setMatchedBackground(this.cc.ConvertStringToColor(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".matchedbackground", this.cc.ConvertColorToString(Color.white))));
        this.options.getEditor().setOutviewEditedFG(this.cc.ConvertStringToColor(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".outvieweditedfg", this.cc.ConvertColorToString(Color.white))));
        this.options.getEditor().setOutviewEditedColor(this.cc.ConvertStringToColor(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".outvieweditedbg", this.cc.ConvertColorToString(this.cc.green))));
        this.options.getEditor().setNavigatorDifferenceBlock(this.cc.ConvertStringToColor(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".navigatordiffblock", this.cc.ConvertColorToString(Color.white))));
        this.options.getEditor().setNavigatorCommonBlock(this.cc.ConvertStringToColor(this.propSettings.getProperty(String.valueOf(this.lastUsedScheme) + ".navigatorcommonblock", this.cc.ConvertColorToString(this.cc.lightestgray))));
        if (this.propSettings.getProperty("legendupordown", "false").equals("true")) {
            this.options.getLayout().setInvokeLegend(true);
        } else {
            this.options.getLayout().setInvokeLegend(false);
        }
        if (this.propSettings.getProperty("navigatorupordown", "false").equals("true")) {
            this.options.getLayout().setInvokeNavigator(true);
        } else {
            this.options.getLayout().setInvokeNavigator(false);
        }
        this.options.getLocation().setPrimeLocation(this.propSettings.getProperty("primelocation", ""));
        this.options.getLocation().setFirstLocation(this.propSettings.getProperty("firstprimelocation", ""));
        this.options.getLocation().setSecondLocation(this.propSettings.getProperty("secondprimelocation", ""));
        this.options.getLocation().setOutputLocation(this.propSettings.getProperty("outputprimelocation", ""));
    }
}

