/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.HDragDivider;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class HDragPanel
extends Panel
implements MouseListener,
MouseMotionListener,
ComponentListener {
    private int grabBarPosX = 450;
    private int grabBarPosY = 450;
    private boolean dragged = false;
    private int previousWidth = 900;
    private int newWidth = 900;

    public HDragPanel() {
        this.addComponentListener(this);
    }

    public Component add(String string, Component component) {
        if (this.getComponentCount() != 0) {
            HDragDivider hDragDivider = new HDragDivider();
            hDragDivider.addMouseListener(this);
            hDragDivider.addMouseMotionListener(this);
            super.add("Center", hDragDivider);
        }
        return super.add(string, component);
    }

    public int getGrabBarX() {
        return this.grabBarPosX;
    }

    public int getGrabBarY() {
        return this.grabBarPosY;
    }

    public void maximizeLeft() {
        this.invalidate();
        this.grabBarPosX = this.getSize().width - 6;
        this.validate();
    }

    public void maximizeRight() {
        this.invalidate();
        this.grabBarPosX = 6;
        this.validate();
    }

    public void resetPanes() {
        this.invalidate();
        this.grabBarPosX = this.getSize().width / 2;
        this.validate();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Cursor cursor = new Cursor(1);
        this.setCursor(cursor);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragged) {
            this.invalidate();
            Component component = this.getComponent(1);
            this.grabBarPosX = mouseEvent.getX() + component.getLocation().x;
            if (this.grabBarPosX >= this.getSize().width - 5) {
                this.grabBarPosX = this.getSize().width - 6;
            } else if (this.grabBarPosX <= 5) {
                this.grabBarPosX = 6;
            }
            this.grabBarPosY = mouseEvent.getY() + component.getLocation().y;
            this.dragged = false;
            this.validate();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Cursor cursor = new Cursor(12);
        this.setCursor(cursor);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.dragged) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dragged = true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.invalidate();
        int n = this.getSize().width;
        this.grabBarPosX = this.grabBarPosX * n / this.previousWidth;
        this.validate();
        this.previousWidth = n;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

